/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import java.util.List;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.stats.ThroughputStats;
import org.graylog2.streams.StreamRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMatcherFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamMatcherFilter.class);
    private final StreamRouter streamRouter;
    private final ThroughputStats throughputStats;

    @Inject
    public StreamMatcherFilter(StreamRouter streamRouter, ThroughputStats throughputStats) {
        this.streamRouter = streamRouter;
        this.throughputStats = throughputStats;
    }

    public boolean filter(Message msg) {
        List<Stream> streams = this.streamRouter.route(msg);
        for (Stream stream : streams) {
            this.throughputStats.incrementStreamThroughput(stream.getId());
        }
        msg.addStreams(streams);
        LOG.debug("Routed message <{}> to {} streams.", (Object)msg.getId(), (Object)streams.size());
        return false;
    }

    public String getName() {
        return "StreamMatcher";
    }

    public int getPriority() {
        return 40;
    }
}

