/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.highlight.HighlightField;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ResultMessage.class);
    private Message message;
    private String index;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Multimap<String, Range<Integer>> highlightRanges;

    protected ResultMessage() {
    }

    public static ResultMessage parseFromSource(SearchHit hit) {
        Map message;
        ResultMessage m = new ResultMessage();
        if (hit.getSource() != null) {
            message = hit.getSource();
        } else {
            message = Maps.newHashMap();
            for (Map.Entry o : hit.fields().entrySet()) {
                message.put(o.getKey(), ((SearchHitField)o.getValue()).getValue());
            }
        }
        m.setMessage(hit.getId(), message);
        m.setIndex(hit.getIndex());
        m.setHighlightRanges(hit.getHighlightFields());
        return m;
    }

    public static ResultMessage parseFromSource(GetResponse r) {
        ResultMessage m = new ResultMessage();
        m.setMessage(r.getId(), r.getSource());
        m.setIndex(r.getIndex());
        return m;
    }

    public void setMessage(String id, Map<String, Object> message) {
        HashMap tmp = Maps.newHashMap();
        tmp.putAll(message);
        tmp.put("_id", id);
        if (tmp.containsKey("timestamp")) {
            Object tsField = tmp.get("timestamp");
            try {
                tmp.put("timestamp", Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(tsField)));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not parse timestamp of message {}", message.get("id"), (Object)e);
            }
        }
        this.message = new Message((Map)tmp);
    }

    public void setHighlightRanges(Map<String, HighlightField> highlightFields) {
        if (!highlightFields.isEmpty()) {
            this.highlightRanges = ArrayListMultimap.create();
            for (Map.Entry<String, HighlightField> hlEntry : highlightFields.entrySet()) {
                int startIdx;
                HighlightField highlight = hlEntry.getValue();
                String s = highlight.fragments()[0].toString();
                int pos = 0;
                int cutChars = 0;
                while ((startIdx = s.indexOf("<em>", pos)) != -1) {
                    int endIdx = s.indexOf("</em>", startIdx);
                    Range highlightPosition = Range.closedOpen((Comparable)Integer.valueOf(startIdx - cutChars), (Comparable)Integer.valueOf(endIdx - cutChars - 4));
                    pos = endIdx;
                    cutChars += 9;
                    this.highlightRanges.put((Object)hlEntry.getKey(), (Object)highlightPosition);
                }
            }
            LOG.debug("Highlight positions for message {}: {}", (Object)this.message.getId(), this.highlightRanges);
        }
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getIndex() {
        return this.index;
    }
}

