/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import com.google.common.base.Optional;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.periodical.IndexRetentionThread;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexCountBasedRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexCountBasedRetentionStrategy.class);
    private final Deflector deflector;
    private final Indices indices;
    private final ActivityWriter activityWriter;

    public AbstractIndexCountBasedRetentionStrategy(Deflector deflector, Indices indices, ActivityWriter activityWriter) {
        this.deflector = deflector;
        this.indices = indices;
        this.activityWriter = activityWriter;
    }

    protected abstract Optional<Integer> getMaxNumberOfIndices();

    protected abstract void retain(String var1);

    public void retain() {
        Map<String, IndexStats> deflectorIndices = this.deflector.getAllDeflectorIndices();
        int indexCount = deflectorIndices.size();
        Optional<Integer> maxIndices = this.getMaxNumberOfIndices();
        if (!maxIndices.isPresent()) {
            LOG.warn("No retention strategy configuration found, not running index retention!");
            return;
        }
        if (indexCount <= (Integer)maxIndices.get()) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, maxIndices);
            return;
        }
        int removeCount = indexCount - (Integer)maxIndices.get();
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxIndices + "). " + "Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        try {
            this.runRetention(deflectorIndices, removeCount);
        }
        catch (NoTargetIndexException e) {
            LOG.error("Could not run index retention. No target index.", (Throwable)e);
        }
    }

    private void runRetention(Map<String, IndexStats> deflectorIndices, int removeCount) throws NoTargetIndexException {
        for (String indexName : IndexHelper.getOldestIndices(deflectorIndices.keySet(), removeCount)) {
            if (indexName.equals(this.deflector.getCurrentActualTargetIndex())) {
                LOG.info("Not running retention against current deflector target <{}>.", (Object)indexName);
                continue;
            }
            if (this.indices.isReopened(indexName)) {
                LOG.info("Not running retention against reopened index <{}>.", (Object)indexName);
                continue;
            }
            String msg = "Running retention strategy [" + this.getClass().getCanonicalName() + "] " + "for index <" + indexName + ">";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            this.retain(indexName);
        }
    }
}

