/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.retention.strategies.AbstractIndexCountBasedRetentionStrategy;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosingRetentionStrategy
extends AbstractIndexCountBasedRetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClosingRetentionStrategy.class);
    private final Indices indices;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public ClosingRetentionStrategy(Deflector deflector, Indices indices, ActivityWriter activityWriter, ClusterConfigService clusterConfigService) {
        super(deflector, indices, activityWriter);
        this.indices = indices;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    protected Optional<Integer> getMaxNumberOfIndices() {
        ClosingRetentionStrategyConfig config = (ClosingRetentionStrategyConfig)this.clusterConfigService.get(ClosingRetentionStrategyConfig.class);
        if (config != null) {
            return Optional.of((Object)config.maxNumberOfIndices());
        }
        return Optional.absent();
    }

    @Override
    public void retain(String indexName) {
        Stopwatch sw = Stopwatch.createStarted();
        this.indices.close(indexName);
        LOG.info("Finished index retention strategy [close] for index <{}> in {}ms.", (Object)indexName, (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    public Class<? extends RetentionStrategyConfig> configurationClass() {
        return ClosingRetentionStrategyConfig.class;
    }

    public RetentionStrategyConfig defaultConfiguration() {
        return ClosingRetentionStrategyConfig.createDefault();
    }
}

