/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import javax.annotation.Nullable;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRotationStrategy
implements RotationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRotationStrategy.class);
    private final Deflector deflector;

    public AbstractRotationStrategy(Deflector deflector) {
        this.deflector = deflector;
    }

    @Nullable
    protected abstract Result shouldRotate(String var1);

    public void rotate() {
        String indexName;
        try {
            indexName = this.deflector.getNewestTargetName();
        }
        catch (NoTargetIndexException e) {
            LOG.error("Could not find current deflector target. Aborting.", (Throwable)e);
            return;
        }
        Result rotate = this.shouldRotate(indexName);
        if (rotate == null) {
            LOG.error("Cannot perform rotation at this moment.");
            return;
        }
        LOG.debug("Rotation strategy result: {}", (Object)rotate.getDescription());
        if (rotate.shouldRotate()) {
            LOG.info("Deflector index <{}> should be rotated, Pointing deflector to new index now!", (Object)indexName);
            this.deflector.cycle();
        } else {
            LOG.debug("Deflector index <{}> should not be rotated. Not doing anything.", (Object)indexName);
        }
    }

    public static interface Result {
        public String getDescription();

        public boolean shouldRotate();
    }
}

