/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.rotation.strategies.AbstractRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountRotationStrategy
extends AbstractRotationStrategy {
    private static final Logger log = LoggerFactory.getLogger(MessageCountRotationStrategy.class);
    private final Indices indices;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public MessageCountRotationStrategy(Indices indices, Deflector deflector, ClusterConfigService clusterConfigService) {
        super(deflector);
        this.indices = indices;
        this.clusterConfigService = clusterConfigService;
    }

    public Class<? extends RotationStrategyConfig> configurationClass() {
        return MessageCountRotationStrategyConfig.class;
    }

    public RotationStrategyConfig defaultConfiguration() {
        return MessageCountRotationStrategyConfig.createDefault();
    }

    @Override
    @Nullable
    protected Result shouldRotate(String index) {
        MessageCountRotationStrategyConfig config = (MessageCountRotationStrategyConfig)this.clusterConfigService.get(MessageCountRotationStrategyConfig.class);
        if (config == null) {
            log.warn("No rotation strategy configuration found, not running index rotation!");
            return null;
        }
        try {
            long numberOfMessages = this.indices.numberOfMessages(index);
            return new Result(index, numberOfMessages, config.maxDocsPerIndex(), numberOfMessages > (long)config.maxDocsPerIndex());
        }
        catch (IndexNotFoundException e) {
            log.error("Unknown index, cannot perform rotation", (Throwable)e);
            return null;
        }
    }

    private static class Result
    implements AbstractRotationStrategy.Result {
        public static final MessageFormat ROTATE_FORMAT = new MessageFormat("Number of messages in <{0}> ({1}) is higher than the limit ({2}). Pointing deflector to new index now!", Locale.ENGLISH);
        public static final MessageFormat NOT_ROTATE_FORMAT = new MessageFormat("Number of messages in <{0}> ({1}) is lower than the limit ({2}). Not doing anything.", Locale.ENGLISH);
        private final String index;
        private final long actualCount;
        private final long maxDocs;
        private final boolean shouldRotate;

        public Result(String index, long actualCount, long maxDocs, boolean shouldRotate) {
            this.index = index;
            this.actualCount = actualCount;
            this.maxDocs = maxDocs;
            this.shouldRotate = shouldRotate;
        }

        @Override
        public String getDescription() {
            MessageFormat format = this.shouldRotate ? ROTATE_FORMAT : NOT_ROTATE_FORMAT;
            return format.format(new Object[]{this.index, this.actualCount, this.maxDocs});
        }

        @Override
        public boolean shouldRotate() {
            return this.shouldRotate;
        }
    }
}

