/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.inputs.PersistedInputs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedInputsImpl
implements PersistedInputs {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedInputsImpl.class);
    private final InputService inputService;
    private final ServerStatus serverStatus;

    @Inject
    public PersistedInputsImpl(InputService inputService, ServerStatus serverStatus) {
        this.inputService = inputService;
        this.serverStatus = serverStatus;
    }

    @Override
    public Iterator<MessageInput> iterator() {
        ArrayList result = Lists.newArrayList();
        for (Input io : this.inputService.allOfThisNode(this.serverStatus.getNodeId().toString())) {
            try {
                MessageInput input = this.inputService.getMessageInput(io);
                result.add(input);
            }
            catch (NoSuchInputTypeException e) {
                LOG.warn("Cannot instantiate persisted input. No such type [{}].", (Object)io.getType());
            }
            catch (Throwable e) {
                LOG.warn("Cannot instantiate persisted input. Exception caught: ", e);
            }
        }
        return result.iterator();
    }

    @Override
    public MessageInput get(String id) {
        try {
            return this.inputService.getMessageInput(this.inputService.find(id));
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Cannot instantiate persisted input: ", (Throwable)e);
        }
        catch (NotFoundException e) {
            LOG.warn("Cannot find persisted Input with id {}", (Object)id);
        }
        return null;
    }

    @Override
    public boolean add(MessageInput input) {
        try {
            Input mongoInput = this.getInput(input);
            String id = this.inputService.save(mongoInput);
            input.setPersistId(id);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof MessageInput) {
            MessageInput messageInput = (MessageInput)o;
            if (Strings.isNullOrEmpty((String)messageInput.getId())) {
                return false;
            }
            try {
                Input input = this.inputService.find(messageInput.getId());
                this.inputService.destroy(input);
                return true;
            }
            catch (NotFoundException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean update(String id, MessageInput newInput) {
        try {
            Input oldInput = this.inputService.find(id);
            newInput.setPersistId(id);
            Input mongoInput = this.getInput(newInput);
            List<Extractor> extractors = this.inputService.getExtractors(oldInput);
            Map<String, String> staticFields = oldInput.getStaticFields();
            this.inputService.save(mongoInput);
            for (Map.Entry<String, String> entry : staticFields.entrySet()) {
                this.inputService.addStaticField(mongoInput, entry.getKey(), entry.getValue());
            }
            for (Extractor extractor : extractors) {
                this.inputService.addExtractor(mongoInput, extractor);
            }
            return true;
        }
        catch (NotFoundException | ValidationException e) {
            return false;
        }
    }

    private Input getInput(MessageInput input) throws ValidationException {
        Map inputData = input.asMap();
        Input mongoInput = input.getId() != null ? this.inputService.create(input.getId(), inputData) : this.inputService.create(inputData);
        return mongoInput;
    }
}

