/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.zip.Deflater;
import java.util.zip.GZIPOutputStream;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.Tools;

public class TestHelper {
    public static byte[] zlibCompress(String what) {
        byte[] input = what.getBytes(StandardCharsets.UTF_8);
        byte[] output = new byte[4096];
        Deflater compresser = new Deflater();
        compresser.setInput(input);
        compresser.finish();
        compresser.deflate(output);
        return output;
    }

    public static byte[] gzipCompress(String what) throws IOException {
        ByteArrayInputStream compressMe = new ByteArrayInputStream(what.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream compressedMessage = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(compressedMessage);){
            ByteStreams.copy((InputStream)compressMe, (OutputStream)out);
        }
        return compressedMessage.toByteArray();
    }

    public static byte[] buildGELFMessageChunk(String idString, int seqNum, int seqCnt, byte[] data) throws Exception {
        byte[] id = idString.getBytes(StandardCharsets.UTF_8);
        if (id.length != 8) {
            throw new Exception("IN TEST HELPER!!! YOU WROTE WRONG YOUR TESTS! - id must consist of 8 byte. length is: " + id.length);
        }
        byte[] chunkData = new byte[12 + data.length];
        chunkData[0] = 30;
        chunkData[1] = 15;
        System.arraycopy(id, 0, chunkData, 2, id.length);
        chunkData[10] = (byte)seqNum;
        chunkData[11] = (byte)seqCnt;
        System.arraycopy(data, 0, chunkData, 12, data.length);
        return chunkData;
    }

    public static String toHex(String arg) {
        return String.format(Locale.ENGLISH, "%x", new BigInteger(arg.getBytes(StandardCharsets.UTF_8)));
    }

    public static Message simpleLogMessage() {
        return new Message("bar", "foo", Tools.nowUTC());
    }
}

