/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.codecs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.inputs.random.generators.FakeHttpRawMessageGenerator;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="random-http-msg", displayName="Random HTTP Message")
public class RandomHttpMessageCodec
extends AbstractCodec {
    private static final Logger log = LoggerFactory.getLogger(RandomHttpMessageCodec.class);
    private final ObjectMapper objectMapper;

    @Inject
    public RandomHttpMessageCodec(@Assisted Configuration configuration, ObjectMapper objectMapper) {
        super(configuration);
        this.objectMapper = objectMapper;
    }

    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        if (!rawMessage.getCodecName().equals(this.getName())) {
            log.error("Cannot decode payload type {}, skipping message {}", (Object)rawMessage.getCodecName(), (Object)rawMessage.getId());
            return null;
        }
        try {
            FakeHttpRawMessageGenerator.GeneratorState state = (FakeHttpRawMessageGenerator.GeneratorState)this.objectMapper.readValue(rawMessage.getPayload(), FakeHttpRawMessageGenerator.GeneratorState.class);
            Message message = FakeHttpRawMessageGenerator.generateMessage(state);
            return message;
        }
        catch (IOException e) {
            log.error("Cannot decode message to class FakeHttpRawMessageGenerator.GeneratorState", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<RandomHttpMessageCodec> {
        public RandomHttpMessageCodec create(Configuration var1);

        public Config getConfig();
    }
}

