/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw.tcp;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Inject;
import org.graylog2.inputs.codecs.RawCodec;
import org.graylog2.inputs.transports.TcpTransport;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;

public class RawTCPInput
extends MessageInput {
    private static final String NAME = "Raw/Plaintext TCP";

    @AssistedInject
    public RawTCPInput(@Assisted Configuration configuration, TcpTransport.Factory tcpTransportFactory, RawCodec.Factory rawCodecFactory, MetricRegistry metricRegistry, LocalMetricRegistry localRegistry, Config config, Descriptor descriptor, ServerStatus serverStatus) {
        super(metricRegistry, configuration, (Transport)tcpTransportFactory.create(configuration), localRegistry, (Codec)rawCodecFactory.create(configuration), (MessageInput.Config)config, (MessageInput.Descriptor)descriptor, serverStatus);
    }

    public static class Config
    extends MessageInput.Config {
        @Inject
        public Config(TcpTransport.Factory transport, RawCodec.Factory codec) {
            super((Transport.Config)transport.getConfig(), (Codec.Config)codec.getConfig());
        }
    }

    public static class Descriptor
    extends MessageInput.Descriptor {
        @Inject
        public Descriptor() {
            super(RawTCPInput.NAME, false, "");
        }
    }

    public static interface Factory
    extends MessageInput.Factory<RawTCPInput> {
        public RawTCPInput create(Configuration var1);

        public Config getConfig();

        public Descriptor getDescriptor();
    }
}

