/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.raw.udp;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import javax.inject.Inject;
import org.graylog2.inputs.codecs.RawCodec;
import org.graylog2.inputs.transports.UdpTransport;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;

public class RawUDPInput
extends MessageInput {
    private static final String NAME = "Raw/Plaintext UDP";

    @AssistedInject
    public RawUDPInput(MetricRegistry metricRegistry, @Assisted Configuration configuration, UdpTransport.Factory udpTransportFactory, RawCodec.Factory rawCodecFactory, LocalMetricRegistry localRegistry, Config config, Descriptor descriptor, ServerStatus serverStatus) {
        super(metricRegistry, configuration, (Transport)udpTransportFactory.create(configuration), localRegistry, (Codec)rawCodecFactory.create(configuration), (MessageInput.Config)config, (MessageInput.Descriptor)descriptor, serverStatus);
    }

    public static class Config
    extends MessageInput.Config {
        @Inject
        public Config(UdpTransport.Factory transport, RawCodec.Factory codec) {
            super((Transport.Config)transport.getConfig(), (Codec.Config)codec.getConfig());
        }
    }

    public static class Descriptor
    extends MessageInput.Descriptor {
        @Inject
        public Descriptor() {
            super(RawUDPInput.NAME, false, "");
        }
    }

    public static interface Factory
    extends MessageInput.Factory<RawUDPInput> {
        public RawUDPInput create(Configuration var1);

        public Config getConfig();

        public Descriptor getDescriptor();
    }
}

