/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Named;
import org.graylog2.inputs.syslog.tcp.SyslogTCPFramingRouterHandler;
import org.graylog2.inputs.transports.TcpTransport;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.channel.ChannelHandler;

public class SyslogTcpTransport
extends TcpTransport {
    @AssistedInject
    public SyslogTcpTransport(@Assisted Configuration configuration, @Named(value="bossPool") Executor bossPool, ThroughputCounter throughputCounter, ConnectionCounter connectionCounter, LocalMetricRegistry localRegistry) {
        super(configuration, bossPool, SyslogTcpTransport.executorService("worker", "syslog-tcp-transport-worker-%d", (MetricRegistry)localRegistry), throughputCounter, connectionCounter, localRegistry);
    }

    private static Executor executorService(String executorName, String threadNameFormat, MetricRegistry metricRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build();
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), metricRegistry, MetricRegistry.name(SyslogTcpTransport.class, (String[])new String[]{executorName, "executor-service"}));
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getFinalChannelHandlers(MessageInput input) {
        LinkedHashMap finalChannelHandlers = Maps.newLinkedHashMap();
        finalChannelHandlers.putAll(super.getFinalChannelHandlers(input));
        finalChannelHandlers.put("framer", new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                return new SyslogTCPFramingRouterHandler(SyslogTcpTransport.this.maxFrameLength, SyslogTcpTransport.this.delimiter);
            }
        });
        return finalChannelHandlers;
    }

    @ConfigClass
    public static class Config
    extends TcpTransport.Config {
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<SyslogTcpTransport> {
        public SyslogTcpTransport create(Configuration var1);
    }
}

