/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.resources.streams.outputs.AvailableOutputSummary;

public class MessageOutputFactory {
    private final Map<String, MessageOutput.Factory<? extends MessageOutput>> availableOutputs;

    @Inject
    public MessageOutputFactory(Map<String, MessageOutput.Factory<? extends MessageOutput>> availableOutputs) {
        this.availableOutputs = availableOutputs;
    }

    public MessageOutput fromStreamOutput(Output output, Stream stream, Configuration configuration) throws MessageOutputConfigurationException {
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)configuration);
        String outputType = output.getType();
        Preconditions.checkArgument((outputType != null ? 1 : 0) != 0);
        MessageOutput.Factory<? extends MessageOutput> factory = this.availableOutputs.get(outputType);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (String)"Output type is not supported: %s!", (Object[])new Object[]{outputType});
        return (MessageOutput)factory.create(stream, configuration);
    }

    public Map<String, AvailableOutputSummary> getAvailableOutputs() {
        HashMap<String, AvailableOutputSummary> result = new HashMap<String, AvailableOutputSummary>(this.availableOutputs.size());
        for (Map.Entry<String, MessageOutput.Factory<? extends MessageOutput>> messageOutputEntry : this.availableOutputs.entrySet()) {
            MessageOutput.Factory<? extends MessageOutput> messageOutputFactoryClass = messageOutputEntry.getValue();
            MessageOutput.Descriptor descriptor = messageOutputFactoryClass.getDescriptor();
            AvailableOutputSummary availableOutputSummary = AvailableOutputSummary.create(descriptor.getName(), messageOutputEntry.getKey(), descriptor.getHumanName(), descriptor.getLinkToDocs(), messageOutputFactoryClass.getConfig().getRequestedConfiguration());
            result.put(messageOutputEntry.getKey(), availableOutputSummary);
        }
        return result;
    }

    public MessageOutput.Factory<? extends MessageOutput> get(String type) {
        return this.availableOutputs.get(type);
    }
}

