/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.SystemJobSummary;
import org.graylog2.rest.resources.system.jobs.RemoteSystemJobResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Jobs", description="Cluster-wide System Jobs")
@Path(value="/cluster/jobs")
public class ClusterSystemJobResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemJobResource.class);
    private final NodeService nodeService;
    private final RemoteInterfaceProvider remoteInterfaceProvider;

    @Inject
    public ClusterSystemJobResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders);
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
    }

    @GET
    @Timed
    @ApiOperation(value="List currently running jobs")
    @Produces(value={"application/json"})
    public Map<String, Map<String, List<SystemJobSummary>>> list() throws IOException {
        Map<String, Node> nodes = this.nodeService.allActive();
        HashMap<String, Map<String, List<SystemJobSummary>>> result = new HashMap<String, Map<String, List<SystemJobSummary>>>(nodes.size());
        nodes.entrySet().stream().forEach(entry -> {
            RemoteSystemJobResource remoteSystemJobResource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.authenticationToken, RemoteSystemJobResource.class);
            try {
                Response response = remoteSystemJobResource.list().execute();
                if (response.isSuccess()) {
                    result.put((String)entry.getKey(), (Map<String, List<SystemJobSummary>>)response.body());
                } else {
                    LOG.warn("Unable to fetch system jobs from node {}: {}", entry.getKey(), (Object)response);
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system jobs from node {}:", entry.getKey(), (Object)e);
            }
        });
        return result;
    }

    @GET
    @Path(value="{jobId}")
    @Timed
    @ApiOperation(value="Get job with the given ID")
    @Produces(value={"application/json"})
    public SystemJobSummary getJob(@ApiParam(name="jobId", required=true) @PathParam(value="jobId") String jobId) throws IOException {
        for (Map.Entry<String, Node> entry : this.nodeService.allActive().entrySet()) {
            RemoteSystemJobResource remoteSystemJobResource = this.remoteInterfaceProvider.get(entry.getValue(), this.authenticationToken, RemoteSystemJobResource.class);
            try {
                Response response = remoteSystemJobResource.get(jobId).execute();
                if (response.isSuccess()) {
                    return (SystemJobSummary)response.body();
                }
                LOG.warn("Unable to fetch system job {} from node {}: {}", new Object[]{jobId, entry.getKey(), response});
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system jobs from node {}:", (Object)entry.getKey(), (Object)e);
            }
        }
        throw new NotFoundException("System job with id " + jobId + " not found!");
    }
}

