/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Optional;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.responses.SystemJVMResponse;
import org.graylog2.rest.models.system.responses.SystemOverviewResponse;
import org.graylog2.rest.models.system.responses.SystemThreadDumpResponse;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteSystemResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster", description="System information of all nodes in the cluster")
@Path(value="/cluster")
@Produces(value={"application/json"})
public class ClusterSystemResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemResource.class);
    private final NodeService nodeService;
    private final RemoteInterfaceProvider remoteInterfaceProvider;

    @Inject
    public ClusterSystemResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders);
        this.nodeService = nodeService;
        this.remoteInterfaceProvider = remoteInterfaceProvider;
    }

    @GET
    @Timed
    @ApiOperation(value="Get system overview of all Graylog nodes")
    public Map<String, Optional<SystemOverviewResponse>> get() {
        Map<String, Node> nodes = this.nodeService.allActive();
        return ((Stream)nodes.entrySet().stream().parallel()).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            RemoteSystemResource remoteSystemResource = this.remoteInterfaceProvider.get((Node)entry.getValue(), this.authenticationToken, RemoteSystemResource.class);
            try {
                Response response = remoteSystemResource.system().execute();
                if (response.isSuccess()) {
                    return Optional.of((Object)response.body());
                }
                LOG.warn("Unable to fetch system overview from node {}: {}", entry.getKey(), (Object)response.message());
            }
            catch (IOException e) {
                LOG.warn("Unable to fetch system overview from node {}:", entry.getKey(), (Object)e);
            }
            return Optional.absent();
        }));
    }

    @GET
    @Timed
    @ApiOperation(value="Get JVM information of the given node")
    @Path(value="{nodeId}/jvm")
    public SystemJVMResponse jvm(@ApiParam(name="nodeId", value="The id of the node where processing will be paused.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemResource remoteSystemResource = this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, RemoteSystemResource.class);
        Response response = remoteSystemResource.jvm().execute();
        if (response.isSuccess()) {
            return (SystemJVMResponse)response.body();
        }
        LOG.warn("Unable to get jvm information on node {}: {}", (Object)nodeId, (Object)response.message());
        throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a thread dump of the given node")
    @RequiresPermissions(value={"threads:dump"})
    @Path(value="{nodeId}/threaddump")
    public SystemThreadDumpResponse threadDump(@ApiParam(name="nodeId", value="The id of the node where processing will be paused.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemResource remoteSystemResource = this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, RemoteSystemResource.class);
        Response response = remoteSystemResource.threadDump().execute();
        if (response.isSuccess()) {
            return (SystemThreadDumpResponse)response.body();
        }
        LOG.warn("Unable to get thread dump on node {}: {}", (Object)nodeId, (Object)response.message());
        throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
    }
}

