/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.search;

import com.codahale.metrics.annotation.Timed;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.glassfish.jersey.server.ChunkedOutput;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.indexer.searches.timeranges.KeywordRange;
import org.graylog2.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.models.search.responses.FieldStatsResult;
import org.graylog2.rest.models.search.responses.HistogramResult;
import org.graylog2.rest.models.search.responses.TermsResult;
import org.graylog2.rest.models.search.responses.TermsStatsResult;
import org.graylog2.rest.resources.search.SearchResource;
import org.graylog2.rest.resources.search.responses.SearchResponse;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Search/Keyword", description="Message search")
@Path(value="/search/universal/keyword")
public class KeywordSearchResource
extends SearchResource {
    private static final Logger LOG = LoggerFactory.getLogger(KeywordSearchResource.class);

    @Inject
    public KeywordSearchResource(Searches searches, ClusterConfigService clusterConfigService) {
        super(searches, clusterConfigService);
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with keyword as timerange.", notes="Search for messages in a timerange defined by a keyword like \"yesterday\" or \"2 weeks ago to wednesday\".")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid keyword provided.")})
    public SearchResponse searchKeyword(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="keyword", value="Range keyword", required=true) @QueryParam(value="keyword") @NotEmpty String keyword, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=false) @QueryParam(value="fields") String fields, @ApiParam(name="sort", value="Sorting (field:asc / field:desc)", required=false) @QueryParam(value="sort") String sort) {
        this.checkSearchPermission(filter, "searches:keyword");
        List<String> fieldList = this.parseOptionalFields(fields);
        Sorting sorting = this.buildSorting(sort);
        TimeRange timeRange = this.buildKeywordTimeRange(keyword);
        SearchesConfig searchesConfig = SearchesConfig.builder().query(query).filter(filter).fields(fieldList).range(timeRange).limit(limit).offset(offset).sorting(sorting).build();
        try {
            return this.buildSearchResponse(this.searches.search(searchesConfig), timeRange);
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    @GET
    @Timed
    @ApiOperation(value="Message search with keyword as timerange.", notes="Search for messages in a timerange defined by a keyword like \"yesterday\" or \"2 weeks ago to wednesday\".")
    @Produces(value={"text/csv"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid keyword provided.")})
    public ChunkedOutput<ScrollResult.ScrollChunk> searchKeywordChunked(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="keyword", value="Range keyword", required=true) @QueryParam(value="keyword") String keyword, @ApiParam(name="limit", value="Maximum number of messages to return.", required=false) @QueryParam(value="limit") int limit, @ApiParam(name="offset", value="Offset", required=false) @QueryParam(value="offset") int offset, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="fields", value="Comma separated list of fields to return", required=true) @QueryParam(value="fields") String fields) {
        this.checkSearchPermission(filter, "searches:keyword");
        List<String> fieldList = this.parseFields(fields);
        TimeRange timeRange = this.buildKeywordTimeRange(keyword);
        try {
            ScrollResult scroll = this.searches.scroll(query, timeRange, limit, offset, fieldList, filter);
            ChunkedOutput output = new ChunkedOutput(ScrollResult.ScrollChunk.class);
            LOG.debug("[{}] Scroll result contains a total of {} messages", (Object)scroll.getQueryHash(), (Object)scroll.totalHits());
            Runnable scrollIterationAction = this.createScrollChunkProducer(scroll, (ChunkedOutput<ScrollResult.ScrollChunk>)output, limit);
            new Thread(scrollIterationAction).start();
            return output;
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    @GET
    @Path(value="/histogram")
    @Timed
    @ApiOperation(value="Datetime histogram of a query using keyword timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided."), @ApiResponse(code=400, message="Invalid interval provided.")})
    @Produces(value={"application/json"})
    public HistogramResult histogramKeyword(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="interval", value="Histogram interval / bucket size. (year, quarter, month, week, day, hour or minute)", required=true) @QueryParam(value="interval") @NotEmpty String interval, @ApiParam(name="keyword", value="Range keyword", required=true) @QueryParam(value="keyword") String keyword, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:keyword");
        interval = interval.toUpperCase(Locale.ENGLISH);
        this.validateInterval(interval);
        try {
            return this.buildHistogramResult(this.searches.histogram(query, Searches.DateHistogramInterval.valueOf(interval), filter, this.buildKeywordTimeRange(keyword)));
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    @GET
    @Path(value="/terms")
    @Timed
    @ApiOperation(value="Most common field terms of a query using a keyword timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public TermsResult termsKeyword(@ApiParam(name="field", value="Message field of to return terms of", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="size", value="Maximum number of terms to return", required=false) @QueryParam(value="size") int size, @ApiParam(name="keyword", value="Range keyword", required=true) @QueryParam(value="keyword") String keyword, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:keyword");
        try {
            return this.buildTermsResult(this.searches.terms(field, size, query, filter, this.buildKeywordTimeRange(keyword)));
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    @GET
    @Path(value="/termsstats")
    @Timed
    @ApiOperation(value="Ordered field terms of a query computed on another field using a keyword timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided.")})
    @Produces(value={"application/json"})
    public TermsStatsResult termsStatsRelative(@ApiParam(name="key_field", value="Message field of to return terms of", required=true) @QueryParam(value="key_field") @NotEmpty String keyField, @ApiParam(name="value_field", value="Value field used for computation", required=true) @QueryParam(value="value_field") @NotEmpty String valueField, @ApiParam(name="order", value="What to order on (Allowed values: TERM, REVERSE_TERM, COUNT, REVERSE_COUNT, TOTAL, REVERSE_TOTAL, MIN, REVERSE_MIN, MAX, REVERSE_MAX, MEAN, REVERSE_MEAN)", required=true) @QueryParam(value="order") @NotEmpty String order, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="size", value="Maximum number of terms to return", required=false) @QueryParam(value="size") int size, @ApiParam(name="keyword", value="Keyword timeframe", required=true) @QueryParam(value="keyword") String keyword, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:keyword");
        try {
            return this.buildTermsStatsResult(this.searches.termsStats(keyField, valueField, Searches.TermsStatsOrder.valueOf(order.toUpperCase(Locale.ENGLISH)), size, query, filter, this.buildKeywordTimeRange(keyword)));
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    @GET
    @Path(value="/stats")
    @Timed
    @ApiOperation(value="Field statistics for a query using a keyword timerange.", notes="Returns statistics like min/max or standard deviation of numeric fields over the whole query result set.")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided."), @ApiResponse(code=400, message="Field is not of numeric type.")})
    public FieldStatsResult statsKeyword(@ApiParam(name="field", value="Message field of numeric type to return statistics for", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="keyword", value="Range keyword", required=true) @QueryParam(value="keyword") String keyword, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter) {
        this.checkSearchPermission(filter, "searches:keyword");
        try {
            return this.buildFieldStatsResult(this.fieldStats(field, query, filter, this.buildKeywordTimeRange(keyword)));
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    @GET
    @Path(value="/fieldhistogram")
    @Timed
    @ApiOperation(value="Datetime histogram of a query using keyword timerange.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid timerange parameters provided."), @ApiResponse(code=400, message="Invalid interval provided."), @ApiResponse(code=400, message="Field is not of numeric type.")})
    @Produces(value={"application/json"})
    public HistogramResult fieldHistogramKeyword(@ApiParam(name="query", value="Query (Lucene syntax)", required=true) @QueryParam(value="query") @NotEmpty String query, @ApiParam(name="field", value="Field of whose values to get the histogram of", required=true) @QueryParam(value="field") @NotEmpty String field, @ApiParam(name="interval", value="Histogram interval / bucket size. (year, quarter, month, week, day, hour or minute)", required=true) @QueryParam(value="interval") @NotEmpty String interval, @ApiParam(name="keyword", value="Range keyword", required=true) @QueryParam(value="keyword") String keyword, @ApiParam(name="filter", value="Filter", required=false) @QueryParam(value="filter") String filter, @ApiParam(name="cardinality", value="Calculate the cardinality of the field as well", required=false) @QueryParam(value="cardinality") boolean includeCardinality) {
        this.checkSearchPermission(filter, "searches:keyword");
        interval = interval.toUpperCase(Locale.ENGLISH);
        this.validateInterval(interval);
        try {
            return this.buildHistogramResult(this.fieldHistogram(field, query, interval, filter, this.buildKeywordTimeRange(keyword), includeCardinality));
        }
        catch (SearchPhaseExecutionException e) {
            throw this.createRequestExceptionForParseFailure(query, e);
        }
    }

    private TimeRange buildKeywordTimeRange(String keyword) {
        try {
            return this.restrictTimeRange(KeywordRange.create(keyword));
        }
        catch (InvalidRangeParametersException e) {
            LOG.warn("Invalid timerange parameters provided. Returning HTTP 400.");
            throw new BadRequestException("Invalid timerange parameters provided", (Throwable)e);
        }
    }
}

