/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.models.system.config.ClusterConfigList;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotBlank;

@Api(value="System/ClusterConfig", description="Graylog Cluster Configuration")
@RequiresAuthentication
@Path(value="/system/cluster_config")
@Produces(value={"application/json"})
public class ClusterConfigResource
extends RestResource {
    private final ClusterConfigService clusterConfigService;

    @Inject
    public ClusterConfigResource(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = Objects.requireNonNull(clusterConfigService);
    }

    @GET
    @ApiOperation(value="List all configuration classes")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public ClusterConfigList list() {
        Set classes = this.clusterConfigService.list();
        return ClusterConfigList.createFromClass(classes);
    }

    @GET
    @Path(value="{configClass}")
    @ApiOperation(value="Get configuration settings from database")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public Object read(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass) {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException("Couldn't find configuration class \"" + configClass + "\"");
        }
        return this.clusterConfigService.get(cls);
    }

    @PUT
    @Timed
    @Path(value="{configClass}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update configuration in database")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    public Response update(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass, @ApiParam(name="body", value="The payload of the cluster configuration", required=true) @NotNull InputStream body) throws IOException {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException("Couldn't find configuration class \"" + configClass + "\"");
        }
        Object o = this.objectMapper.readValue(body, cls);
        this.clusterConfigService.write(o);
        return Response.accepted((Object)o).build();
    }

    @DELETE
    @Path(value="{configClass}")
    @ApiOperation(value="Delete configuration settings from database")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:delete"})
    public void delete(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass) {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException("Couldn't find configuration class \"" + configClass + "\"");
        }
        this.clusterConfigService.remove(cls);
    }

    @GET
    @Path(value="{configClass}")
    @Produces(value={"application/schema+json"})
    @ApiOperation(value="Get JSON schema of configuration class")
    @Timed
    @RequiresPermissions(value={"clusterconfigentry:read"})
    public JsonSchema schema(@ApiParam(name="configClass", value="The name of the cluster configuration class", required=true) @PathParam(value="configClass") @NotBlank String configClass) {
        Class<?> cls = this.classFromName(configClass);
        if (cls == null) {
            throw new NotFoundException("Couldn't find configuration class \"" + configClass + "\"");
        }
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        try {
            this.objectMapper.acceptJsonFormatVisitor(this.objectMapper.constructType(cls), (JsonFormatVisitorWrapper)visitor);
        }
        catch (JsonMappingException e) {
            throw new InternalServerErrorException("Couldn't generate JSON schema for configuration class " + configClass, (Throwable)e);
        }
        return visitor.finalSchema();
    }

    @Nullable
    private Class<?> classFromName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

