/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indices;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.rest.models.system.indices.RetentionStrategies;
import org.graylog2.rest.models.system.indices.RetentionStrategyDescription;
import org.graylog2.rest.models.system.indices.RetentionStrategySummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;

@Api(value="System/Indices/Retention", description="Index retention strategy settings")
@Path(value="/system/indices/retention")
@Produces(value={"application/json"})
@RequiresAuthentication
public class RetentionStrategyResource
extends RestResource {
    private final Map<String, Provider<RetentionStrategy>> retentionStrategies;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public RetentionStrategyResource(Map<String, Provider<RetentionStrategy>> retentionStrategies, ClusterConfigService clusterConfigService) {
        this.retentionStrategies = Objects.requireNonNull(retentionStrategies);
        this.clusterConfigService = Objects.requireNonNull(clusterConfigService);
    }

    @GET
    @Path(value="config")
    @Timed
    @ApiOperation(value="Configuration of the current retention strategy", notes="This resource returns the configuration of the currently used retention strategy.")
    public RetentionStrategySummary config() {
        IndexManagementConfig indexManagementConfig = (IndexManagementConfig)this.clusterConfigService.get(IndexManagementConfig.class);
        if (indexManagementConfig == null) {
            throw new InternalServerErrorException("Couldn't retrieve index management configuration");
        }
        String strategyName = indexManagementConfig.retentionStrategy();
        Provider<RetentionStrategy> provider = this.retentionStrategies.get(strategyName);
        if (provider == null) {
            throw new InternalServerErrorException("Couldn't retrieve retention strategy provider");
        }
        RetentionStrategy retentionStrategy = (RetentionStrategy)provider.get();
        Class configClass = retentionStrategy.configurationClass();
        RetentionStrategyConfig config = (RetentionStrategyConfig)this.clusterConfigService.get(configClass);
        return RetentionStrategySummary.create(strategyName, config);
    }

    @PUT
    @Path(value="config")
    @Consumes(value={"application/json"})
    @Timed
    @ApiOperation(value="Configuration of the current retention strategy", notes="This resource stores the configuration of the currently used retention strategy.")
    public RetentionStrategySummary config(@ApiParam(value="The description of the retention strategy and its configuration", required=true) @Valid @NotNull RetentionStrategySummary retentionStrategySummary) {
        if (!this.retentionStrategies.containsKey(retentionStrategySummary.strategy())) {
            throw new NotFoundException("Couldn't find retention strategy for given type " + retentionStrategySummary.strategy());
        }
        IndexManagementConfig oldConfig = (IndexManagementConfig)this.clusterConfigService.get(IndexManagementConfig.class);
        if (oldConfig == null) {
            throw new InternalServerErrorException("Couldn't retrieve index management configuration");
        }
        IndexManagementConfig indexManagementConfig = IndexManagementConfig.create(oldConfig.rotationStrategy(), retentionStrategySummary.strategy());
        this.clusterConfigService.write((Object)retentionStrategySummary.config());
        this.clusterConfigService.write((Object)indexManagementConfig);
        return retentionStrategySummary;
    }

    @GET
    @Path(value="strategies")
    @Timed
    @ApiOperation(value="List available retention strategies", notes="This resource returns a list of all available retention strategies on this Graylog node.")
    public RetentionStrategies list() {
        Set<RetentionStrategyDescription> strategies = this.retentionStrategies.keySet().stream().map(this::getRetentionStrategyDescription).collect(Collectors.toSet());
        return RetentionStrategies.create(strategies.size(), strategies);
    }

    @GET
    @Path(value="strategies/{strategy}")
    @Timed
    @ApiOperation(value="Show JSON schema for configuration of given retention strategies", notes="This resource returns a JSON schema for the configuration of the given retention strategy.")
    public RetentionStrategyDescription configSchema(@ApiParam(name="strategy", value="The name of the retention strategy", required=true) @PathParam(value="strategy") @NotEmpty String strategyName) {
        return this.getRetentionStrategyDescription(strategyName);
    }

    private RetentionStrategyDescription getRetentionStrategyDescription(@ApiParam(name="strategy", value="The name of the retention strategy", required=true) @PathParam(value="strategy") @NotEmpty String strategyName) {
        Provider<RetentionStrategy> provider = this.retentionStrategies.get(strategyName);
        if (provider == null) {
            throw new NotFoundException("Couldn't find retention strategy for given type " + strategyName);
        }
        RetentionStrategy retentionStrategy = (RetentionStrategy)provider.get();
        RetentionStrategyConfig defaultConfig = retentionStrategy.defaultConfiguration();
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        try {
            this.objectMapper.acceptJsonFormatVisitor(this.objectMapper.constructType((Type)retentionStrategy.configurationClass()), (JsonFormatVisitorWrapper)visitor);
        }
        catch (JsonMappingException e) {
            throw new InternalServerErrorException("Couldn't generate JSON schema for retention strategy " + strategyName, (Throwable)e);
        }
        return RetentionStrategyDescription.create(strategyName, defaultConfig, visitor.finalSchema());
    }
}

