/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.inputs;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.events.inputs.IOStateChangedEvent;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(InputStateListener.class);

    @Inject
    public InputStateListener(EventBus eventBus) {
        eventBus.register((Object)this);
    }

    @Subscribe
    public void inputStateChanged(IOStateChangedEvent<MessageInput> event) {
        IOState state = event.changedState();
        MessageInput input = (MessageInput)state.getStoppable();
        LOG.debug("Input State of {} changed: {} -> {}", new Object[]{input.getTitle(), event.oldState(), event.newState()});
        String msg = "Input [" + input.getName() + "/" + input.getId() + "] is now " + event.newState().toString();
        LOG.info(msg);
    }
}

