/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.grizzly.http.server.Response;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAccessLogFilter
implements ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.graylog2.rest.accesslog");
    private final Response response;

    public RestAccessLogFilter(@Context Response response) {
        this.response = Objects.requireNonNull(response);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            try {
                String rawQuery = requestContext.getUriInfo().getRequestUri().getRawQuery();
                SecurityContext securityContext = requestContext.getSecurityContext();
                String remoteUser = securityContext instanceof ShiroSecurityContext ? ((ShiroSecurityContext)securityContext).getUsername() : null;
                Date requestDate = requestContext.getDate();
                LOG.debug("{} {} [{}] \"{} {}{}\" {} {} {}", new Object[]{this.response.getRequest().getRemoteAddr(), remoteUser == null ? "-" : remoteUser, requestDate == null ? "-" : requestDate, requestContext.getMethod(), requestContext.getUriInfo().getPath(), rawQuery == null ? "" : "?" + rawQuery, requestContext.getHeaderString("User-Agent"), responseContext.getStatus(), responseContext.getLength()});
            }
            catch (Exception e) {
                LOG.error("Error while processing REST API access log", (Throwable)e);
            }
        }
    }
}

