/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Iterables;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.plugin.GlobalMetricNames;
import org.graylog2.rest.models.system.responses.Throughput;
import org.graylog2.shared.metrics.MetricUtils;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/Throughput", description="Message throughput of this node")
@Path(value="/system/throughput")
public class ThroughputResource
extends RestResource {
    private final MetricRegistry metricRegistry;

    @Inject
    public ThroughputResource(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @GET
    @Timed
    @RequiresPermissions(value={"throughput:read"})
    @ApiOperation(value="Current throughput of this node in messages per second")
    @Produces(value={"application/json"})
    public Throughput total() {
        SortedMap gauges = this.metricRegistry.getGauges(MetricUtils.filterSingleMetric(GlobalMetricNames.OUTPUT_THROUGHPUT_RATE));
        Gauge gauge = (Gauge)Iterables.getOnlyElement(gauges.values(), null);
        if (gauge == null || !(gauge.getValue() instanceof Number)) {
            return Throughput.create(0L);
        }
        return Throughput.create(((Number)gauge.getValue()).longValue());
    }
}

