/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alerts.AlertService;
import org.graylog2.bundles.BundleService;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.InputService;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.graylog2.shared.users.UserService;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.system.stats.AlarmStats;
import org.graylog2.system.stats.ClusterStats;
import org.graylog2.system.stats.LdapStats;
import org.graylog2.system.stats.elasticsearch.ElasticsearchProbe;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.mongo.MongoProbe;
import org.graylog2.system.stats.mongo.MongoStats;
import org.graylog2.users.RoleService;

@Singleton
public class ClusterStatsService {
    private final ElasticsearchProbe elasticsearchProbe;
    private final MongoProbe mongoProbe;
    private final UserService userService;
    private final InputService inputService;
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final OutputService outputService;
    private final DashboardService dashboardService;
    private final BundleService bundleService;
    private final LdapSettingsService ldapSettingsService;
    private final RoleService roleService;
    private final AlertService alertService;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;

    @Inject
    public ClusterStatsService(ElasticsearchProbe elasticsearchProbe, MongoProbe mongoProbe, UserService userService, InputService inputService, StreamService streamService, StreamRuleService streamRuleService, OutputService outputService, DashboardService dashboardService, BundleService bundleService, LdapSettingsService ldapSettingsService, RoleService roleService, AlertService alertService, AlarmCallbackConfigurationService alarmCallbackConfigurationService) {
        this.elasticsearchProbe = elasticsearchProbe;
        this.mongoProbe = mongoProbe;
        this.userService = userService;
        this.inputService = inputService;
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.outputService = outputService;
        this.dashboardService = dashboardService;
        this.bundleService = bundleService;
        this.ldapSettingsService = ldapSettingsService;
        this.roleService = roleService;
        this.alertService = alertService;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
    }

    public ClusterStats clusterStats() {
        return ClusterStats.create(this.elasticsearchStats(), this.mongoStats(), this.streamService.count(), this.streamRuleService.totalStreamRuleCount(), this.streamRuleService.streamRuleCountByStream(), this.userService.count(), this.outputService.count(), this.outputService.countByType(), this.dashboardService.count(), this.inputService.totalCount(), this.inputService.globalCount(), this.inputService.totalCountByType(), this.inputService.totalExtractorCount(), this.inputService.totalExtractorCountByType(), this.bundleService.count(), this.ldapStats(), this.alarmStats());
    }

    public ElasticsearchStats elasticsearchStats() {
        return this.elasticsearchProbe.elasticsearchStats();
    }

    public MongoStats mongoStats() {
        return this.mongoProbe.mongoStats();
    }

    public LdapStats ldapStats() {
        int numberOfRoles = 0;
        LdapSettings ldapSettings = null;
        try {
            numberOfRoles = this.roleService.loadAll().size();
            ldapSettings = this.ldapSettingsService.load();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (ldapSettings == null) {
            return LdapStats.create(false, false, 0, numberOfRoles);
        }
        return LdapStats.create(ldapSettings.isEnabled(), ldapSettings.isActiveDirectory(), ldapSettings.getGroupMapping().size(), numberOfRoles);
    }

    public AlarmStats alarmStats() {
        long totalCount = this.alertService.totalCount();
        Map<String, Long> counterPerType = this.alarmCallbackConfigurationService.countPerType();
        return AlarmStats.create(totalCount, counterPerType);
    }
}

