/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.stats.elasticsearch;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import javax.inject.Inject;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodes;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksRequest;
import org.elasticsearch.action.admin.cluster.tasks.PendingClusterTasksResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.system.stats.elasticsearch.ClusterHealth;
import org.graylog2.system.stats.elasticsearch.ElasticsearchStats;
import org.graylog2.system.stats.elasticsearch.IndicesStats;
import org.graylog2.system.stats.elasticsearch.NodesStats;

@Singleton
public class ElasticsearchProbe {
    private final Client client;
    private final Indices indices;

    @Inject
    public ElasticsearchProbe(Client client, Indices indices) {
        this.client = client;
        this.indices = indices;
    }

    public ElasticsearchStats elasticsearchStats() {
        ClusterAdminClient adminClient = this.client.admin().cluster();
        ClusterStatsResponse clusterStatsResponse = (ClusterStatsResponse)adminClient.clusterStats(new ClusterStatsRequest()).actionGet();
        String clusterName = clusterStatsResponse.getClusterNameAsString();
        ClusterStatsNodes clusterNodesStats = clusterStatsResponse.getNodesStats();
        NodesStats nodesStats = NodesStats.create(clusterNodesStats.getCounts().getTotal(), clusterNodesStats.getCounts().getMasterOnly(), clusterNodesStats.getCounts().getDataOnly(), clusterNodesStats.getCounts().getMasterData(), clusterNodesStats.getCounts().getClient());
        IndicesStats indicesStats = IndicesStats.create(clusterStatsResponse.getIndicesStats().getIndexCount(), clusterStatsResponse.getIndicesStats().getStore().sizeInBytes(), clusterStatsResponse.getIndicesStats().getFieldData().getMemorySizeInBytes());
        PendingClusterTasksResponse pendingClusterTasksResponse = (PendingClusterTasksResponse)adminClient.pendingClusterTasks(new PendingClusterTasksRequest()).actionGet();
        int pendingTasksSize = pendingClusterTasksResponse.pendingTasks().size();
        ArrayList pendingTasksTimeInQueue = Lists.newArrayListWithCapacity((int)pendingTasksSize);
        for (PendingClusterTask pendingClusterTask : pendingClusterTasksResponse) {
            pendingTasksTimeInQueue.add(pendingClusterTask.getTimeInQueueInMillis());
        }
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)adminClient.health(new ClusterHealthRequest(new String[]{this.indices.allIndicesAlias()})).actionGet();
        ClusterHealth clusterHealth = ClusterHealth.create(clusterHealthResponse.getNumberOfNodes(), clusterHealthResponse.getNumberOfDataNodes(), clusterHealthResponse.getActiveShards(), clusterHealthResponse.getRelocatingShards(), clusterHealthResponse.getActivePrimaryShards(), clusterHealthResponse.getInitializingShards(), clusterHealthResponse.getUnassignedShards(), clusterHealthResponse.isTimedOut(), pendingTasksSize, pendingTasksTimeInQueue);
        return ElasticsearchStats.create(clusterName, clusterHealthResponse.getStatus(), clusterHealth, nodesStats, indicesStats);
    }
}

