webpackJsonp([29],{68:function(module,exports,__webpack_require__){eval('/*! Moment Duration Format v1.3.0\n *  https://github.com/jsmreese/moment-duration-format \n *  Date: 2014-07-15\n *\n *  Duration format plugin function for the Moment.js library\n *  http://momentjs.com/\n *\n *  Copyright 2014 John Madhavan-Reese\n *  Released under the MIT license\n */\n\n(function (root, undefined) {\n\n	// repeatZero(qty)\n	// returns "0" repeated qty times\n	function repeatZero(qty) {\n		var result = "";\n		\n		// exit early\n		// if qty is 0 or a negative number\n		// or doesn\'t coerce to an integer\n		qty = parseInt(qty, 10);\n		if (!qty || qty < 1) { return result; }\n		\n		while (qty) {\n			result += "0";\n			qty -= 1;\n		}\n		\n		return result;\n	}\n	\n	// padZero(str, len [, isRight])\n	// pads a string with zeros up to a specified length\n	// will not pad a string if its length is aready\n	// greater than or equal to the specified length\n	// default output pads with zeros on the left\n	// set isRight to `true` to pad with zeros on the right\n	function padZero(str, len, isRight) {\n		if (str == null) { str = ""; }\n		str = "" + str;\n		\n		return (isRight ? str : "") + repeatZero(len - str.length) + (isRight ? "" : str);\n	}\n	\n	// isArray\n	function isArray(array) {\n		return Object.prototype.toString.call(array) === "[object Array]";\n	}\n	\n	// isObject\n	function isObject(obj) {\n		return Object.prototype.toString.call(obj) === "[object Object]";\n	}\n	\n	// findLast\n	function findLast(array, callback) {\n		var index = array.length;\n\n		while (index -= 1) {\n			if (callback(array[index])) { return array[index]; }\n		}\n	}\n\n	// find\n	function find(array, callback) {\n		var index = 0,\n			max = array.length,\n			match;\n			\n		if (typeof callback !== "function") {\n			match = callback;\n			callback = function (item) {\n				return item === match;\n			};\n		}\n\n		while (index < max) {\n			if (callback(array[index])) { return array[index]; }\n			index += 1;\n		}\n	}\n	\n	// each\n	function each(array, callback) {\n		var index = 0,\n			max = array.length;\n			\n		if (!array || !max) { return; }\n\n		while (index < max) {\n			if (callback(array[index], index) === false) { return; }\n			index += 1;\n		}\n	}\n	\n	// map\n	function map(array, callback) {\n		var index = 0,\n			max = array.length,\n			ret = [];\n\n		if (!array || !max) { return ret; }\n				\n		while (index < max) {\n			ret[index] = callback(array[index], index);\n			index += 1;\n		}\n		\n		return ret;\n	}\n	\n	// pluck\n	function pluck(array, prop) {\n		return map(array, function (item) {\n			return item[prop];\n		});\n	}\n	\n	// compact\n	function compact(array) {\n		var ret = [];\n		\n		each(array, function (item) {\n			if (item) { ret.push(item); }\n		});\n		\n		return ret;\n	}\n	\n	// unique\n	function unique(array) {\n		var ret = [];\n		\n		each(array, function (_a) {\n			if (!find(ret, _a)) { ret.push(_a); }\n		});\n		\n		return ret;\n	}\n	\n	// intersection\n	function intersection(a, b) {\n		var ret = [];\n		\n		each(a, function (_a) {\n			each(b, function (_b) {\n				if (_a === _b) { ret.push(_a); }\n			});\n		});\n		\n		return unique(ret);\n	}\n	\n	// rest\n	function rest(array, callback) {\n		var ret = [];\n		\n		each(array, function (item, index) {\n			if (!callback(item)) {\n				ret = array.slice(index);\n				return false;\n			}\n		});\n		\n		return ret;\n	}\n\n	// initial\n	function initial(array, callback) {\n		var reversed = array.slice().reverse();\n		\n		return rest(reversed, callback).reverse();\n	}\n	\n	// extend\n	function extend(a, b) {\n		for (var key in b) {\n			if (b.hasOwnProperty(key)) { a[key] = b[key]; }\n		}\n		\n		return a;\n	}\n			\n	// define internal moment reference\n	var moment;\n\n	if (true) {\n		try { moment = __webpack_require__(19); } \n		catch (e) {}\n	} \n	\n	if (!moment && root.moment) {\n		moment = root.moment;\n	}\n	\n	if (!moment) {\n		throw "Moment Duration Format cannot find Moment.js";\n	}\n	\n	// moment.duration.format([template] [, precision] [, settings])\n	moment.duration.fn.format = function () {\n\n		var tokenizer, tokens, types, typeMap, momentTypes, foundFirst, trimIndex,\n			args = [].slice.call(arguments),\n			settings = extend({}, this.format.defaults),\n			// keep a shadow copy of this moment for calculating remainders\n			remainder = moment.duration(this);\n\n		// add a reference to this duration object to the settings for use\n		// in a template function\n		settings.duration = this;\n\n		// parse arguments\n		each(args, function (arg) {\n			if (typeof arg === "string" || typeof arg === "function") {\n				settings.template = arg;\n				return;\n			}\n\n			if (typeof arg === "number") {\n				settings.precision = arg;\n				return;\n			}\n\n			if (isObject(arg)) {\n				extend(settings, arg);\n			}\n		});\n\n		// types\n		types = settings.types = (isArray(settings.types) ? settings.types : settings.types.split(" "));\n\n		// template\n		if (typeof settings.template === "function") {\n			settings.template = settings.template.apply(settings);\n		}\n\n		// tokenizer regexp\n		tokenizer = new RegExp(map(types, function (type) {\n			return settings[type].source;\n		}).join("|"), "g");\n\n		// token type map function\n		typeMap = function (token) {\n			return find(types, function (type) {\n				return settings[type].test(token);\n			});\n		};\n\n		// tokens array\n		tokens = map(settings.template.match(tokenizer), function (token, index) {\n			var type = typeMap(token),\n				length = token.length;\n\n			return {\n				index: index,\n				length: length,\n\n				// replace escaped tokens with the non-escaped token text\n				token: (type === "escape" ? token.replace(settings.escape, "$1") : token),\n\n				// ignore type on non-moment tokens\n				type: ((type === "escape" || type === "general") ? null : type)\n\n				// calculate base value for all moment tokens\n				//baseValue: ((type === "escape" || type === "general") ? null : this.as(type))\n			};\n		}, this);\n\n		// unique moment token types in the template (in order of descending magnitude)\n		momentTypes = intersection(types, unique(compact(pluck(tokens, "type"))));\n\n		// exit early if there are no momentTypes\n		if (!momentTypes.length) {\n			return pluck(tokens, "token").join("");\n		}\n\n		// calculate values for each token type in the template\n		each(momentTypes, function (momentType, index) {\n			var value, wholeValue, decimalValue, isLeast, isMost;\n\n			// calculate integer and decimal value portions\n			value = remainder.as(momentType);\n			wholeValue = (value > 0 ? Math.floor(value) : Math.ceil(value));\n			decimalValue = value - wholeValue;\n\n			// is this the least-significant moment token found?\n			isLeast = ((index + 1) === momentTypes.length);\n\n			// is this the most-significant moment token found?\n			isMost = (!index);\n\n			// update tokens array\n			// using this algorithm to not assume anything about\n			// the order or frequency of any tokens\n			each(tokens, function (token) {\n				if (token.type === momentType) {\n					extend(token, {\n						value: value,\n						wholeValue: wholeValue,\n						decimalValue: decimalValue,\n						isLeast: isLeast,\n						isMost: isMost\n					});\n\n					if (isMost) {\n						// note the length of the most-significant moment token:\n						// if it is greater than one and forceLength is not set, default forceLength to `true`\n						if (settings.forceLength == null && token.length > 1) {\n							settings.forceLength = true;\n						}\n\n						// rationale is this:\n						// if the template is "h:mm:ss" and the moment value is 5 minutes, the user-friendly output is "5:00", not "05:00"\n						// shouldn\'t pad the `minutes` token even though it has length of two\n						// if the template is "hh:mm:ss", the user clearly wanted everything padded so we should output "05:00"\n						// if the user wanted the full padded output, they can set `{ trim: false }` to get "00:05:00"\n					}\n				}\n			});\n\n			// update remainder\n			remainder.subtract(wholeValue, momentType);\n		});\n	\n		// trim tokens array\n		if (settings.trim) {\n			tokens = (settings.trim === "left" ? rest : initial)(tokens, function (token) {\n				// return `true` if:\n				// the token is not the least moment token (don\'t trim the least moment token)\n				// the token is a moment token that does not have a value (don\'t trim moment tokens that have a whole value)\n				return !(token.isLeast || (token.type != null && token.wholeValue));\n			});\n		}\n		\n		\n		// build output\n\n		// the first moment token can have special handling\n		foundFirst = false;\n\n		// run the map in reverse order if trimming from the right\n		if (settings.trim === "right") {\n			tokens.reverse();\n		}\n\n		tokens = map(tokens, function (token) {\n			var val,\n				decVal;\n\n			if (!token.type) {\n				// if it is not a moment token, use the token as its own value\n				return token.token;\n			}\n\n			// apply negative precision formatting to the least-significant moment token\n			if (token.isLeast && (settings.precision < 0)) {\n				val = (Math.floor(token.wholeValue * Math.pow(10, settings.precision)) * Math.pow(10, -settings.precision)).toString();\n			} else {\n				val = token.wholeValue.toString();\n			}\n			\n			// remove negative sign from the beginning\n			val = val.replace(/^\\-/, "");\n\n			// apply token length formatting\n			// special handling for the first moment token that is not the most significant in a trimmed template\n			if (token.length > 1 && (foundFirst || token.isMost || settings.forceLength)) {\n				val = padZero(val, token.length);\n			}\n\n			// add decimal value if precision > 0\n			if (token.isLeast && (settings.precision > 0)) {\n				decVal = token.decimalValue.toString().replace(/^\\-/, "").split(/\\.|e\\-/);\n				switch (decVal.length) {\n					case 1:\n						val += "." + padZero(decVal[0], settings.precision, true).slice(0, settings.precision);\n						break;\n						\n					case 2:\n						val += "." + padZero(decVal[1], settings.precision, true).slice(0, settings.precision);		\n						break;\n						\n					case 3:\n						val += "." + padZero(repeatZero((+decVal[2]) - 1) + (decVal[0] || "0") + decVal[1], settings.precision, true).slice(0, settings.precision);		\n						break;\n					\n					default:\n						throw "Moment Duration Format: unable to parse token decimal value.";\n				}\n			}\n			\n			// add a negative sign if the value is negative and token is most significant\n			if (token.isMost && token.value < 0) {\n				val = "-" + val;\n			}\n\n			foundFirst = true;\n\n			return val;\n		});\n\n		// undo the reverse if trimming from the right\n		if (settings.trim === "right") {\n			tokens.reverse();\n		}\n\n		return tokens.join("");\n	};\n\n	moment.duration.fn.format.defaults = {\n		// token definitions\n		escape: /\\[(.+?)\\]/,\n		years: /[Yy]+/,\n		months: /M+/,\n		weeks: /[Ww]+/,\n		days: /[Dd]+/,\n		hours: /[Hh]+/,\n		minutes: /m+/,\n		seconds: /s+/,\n		milliseconds: /S+/,\n		general: /.+?/,\n\n		// token type names\n		// in order of descending magnitude\n		// can be a space-separated token name list or an array of token names\n		types: "escape years months weeks days hours minutes seconds milliseconds general",\n\n		// format options\n\n		// trim\n		// "left" - template tokens are trimmed from the left until the first moment token that has a value >= 1\n		// "right" - template tokens are trimmed from the right until the first moment token that has a value >= 1\n		// (the final moment token is not trimmed, regardless of value)\n		// `false` - template tokens are not trimmed\n		trim: "left",\n\n		// precision\n		// number of decimal digits to include after (to the right of) the decimal point (positive integer)\n		// or the number of digits to truncate to 0 before (to the left of) the decimal point (negative integer)\n		precision: 0,\n\n		// force first moment token with a value to render at full length even when template is trimmed and first moment token has length of 1\n		forceLength: null,\n\n		// template used to format duration\n		// may be a function or a string\n		// template functions are executed with the `this` binding of the settings object\n		// so that template strings may be dynamically generated based on the duration object\n		// (accessible via `this.duration`)\n		// or any of the other settings\n		template: function () {\n			var types = this.types,\n				dur = this.duration,\n				lastType = findLast(types, function (type) {\n					return dur._data[type];\n				});\n\n			// default template strings for each duration dimension type\n			switch (lastType) {\n				case "seconds":\n					return "h:mm:ss";\n				case "minutes":\n					return "d[d] h:mm";\n				case "hours":\n					return "d[d] h[h]";\n				case "days":\n					return "M[m] d[d]";\n				case "weeks":\n					return "y[y] w[w]";\n				case "months":\n					return "y[y] M[m]";\n				case "years":\n					return "y[y]";\n				default:\n					return "y[y] M[m] d[d] h:mm:ss";\n			}\n		}\n	};\n\n})(this);\n\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/moment-duration-format/lib/moment-duration-format.js\n ** module id = 68\n ** module chunks = 5 12 13 29\n **/\n//# sourceURL=webpack:///./~/moment-duration-format/lib/moment-duration-format.js?')},434:function(module,exports,__webpack_require__){eval('exports = module.exports = __webpack_require__(26)();\n// imports\n\n\n// module\nexports.push([module.id, "._3wNSqWQmctnrH81NNyBNJr{margin-top:10px}._3wNSqWQmctnrH81NNyBNJr dt{float:left;clear:left}._3wNSqWQmctnrH81NNyBNJr dd{margin-left:150px}._1mMgzVJ6bzKGk8qpBapKzA dd{margin-left:200px}._1ciaaz99VC0SGyABGt-93I{margin-top:10px}hr._1ToG-wLLXinM_eKFQvB-Gy{margin-top:10px;margin-bottom:5px}", ""]);\n\n// exports\nexports.locals = {\n	"deflist": "_3wNSqWQmctnrH81NNyBNJr",\n	"deflistWide": "_1mMgzVJ6bzKGk8qpBapKzA",\n	"topMargin": "_1ciaaz99VC0SGyABGt-93I",\n	"separator": "_1ToG-wLLXinM_eKFQvB-Gy"\n};\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/css-loader!./src/components/configurations/ConfigurationStyles.css\n ** module id = 434\n ** module chunks = 29\n **/\n//# sourceURL=webpack:///./src/components/configurations/ConfigurationStyles.css?./~/css-loader')},650:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _componentsBootstrapBootstrapModalForm = __webpack_require__(28);\n\nvar _componentsBootstrapBootstrapModalForm2 = _interopRequireDefault(_componentsBootstrapBootstrapModalForm);\n\nvar _componentsCommon = __webpack_require__(4);\n\nvar _utilObjectUtils = __webpack_require__(125);\n\nvar _utilObjectUtils2 = _interopRequireDefault(_utilObjectUtils);\n\nvar _moment = __webpack_require__(19);\n\nvar _moment2 = _interopRequireDefault(_moment);\n\n__webpack_require__(68);\n\nvar _styleCssComponentsConfigurationsConfigurationStylesCss = __webpack_require__(922);\n\nvar _styleCssComponentsConfigurationsConfigurationStylesCss2 = _interopRequireDefault(_styleCssComponentsConfigurationsConfigurationStylesCss);\n\nvar SearchesConfig = _react2['default'].createClass({\n  displayName: 'SearchesConfig',\n\n  propTypes: {\n    config: _react2['default'].PropTypes.object.isRequired,\n    updateConfig: _react2['default'].PropTypes.func.isRequired\n  },\n\n  getInitialState: function getInitialState() {\n    var queryTimeRangeLimit = this._getPropConfigValue('query_time_range_limit');\n    var relativeTimerangeOptions = this._getPropConfigValue('relative_timerange_options');\n\n    return {\n      config: {\n        query_time_range_limit: queryTimeRangeLimit,\n        relative_timerange_options: relativeTimerangeOptions\n      },\n      timerangeOptionsList: this._createTimerangeOptionsState(relativeTimerangeOptions),\n      limitEnabled: _moment2['default'].duration(queryTimeRangeLimit).asMilliseconds() > 0\n    };\n  },\n\n  _getPropConfigValue: function _getPropConfigValue(field) {\n    return this.props.config ? this.props.config[field] : null;\n  },\n\n  // Converts the object to a list of objects to make form handling easier.\n  _createTimerangeOptionsState: function _createTimerangeOptionsState(options) {\n    var optionsList = null;\n\n    if (options) {\n      optionsList = Object.keys(options).map(function (key) {\n        return { period: key, description: options[key] };\n      });\n    }\n\n    return optionsList;\n  },\n\n  _updateTimerangeOptionsState: function _updateTimerangeOptionsState(options) {\n    var config = _utilObjectUtils2['default'].clone(this.state.config);\n    var newTimerangeOptions = {};\n\n    options.forEach(function (option) {\n      newTimerangeOptions[option.period] = option.description;\n    });\n\n    config.relative_timerange_options = newTimerangeOptions;\n\n    this.setState({ config: config, timerangeOptionsList: options });\n  },\n\n  _isValidPeriod: function _isValidPeriod(duration) {\n    var check = duration || this.state.config.query_time_range_limit;\n    return _moment2['default'].duration(check).asMilliseconds() >= 0;\n  },\n\n  _validationState: function _validationState() {\n    if (this._isValidPeriod()) {\n      return undefined;\n    } else {\n      return 'error';\n    }\n  },\n\n  _formatDuration: function _formatDuration(duration) {\n    return this._isValidPeriod() ? _moment2['default'].duration(duration).humanize() : 'invalid';\n  },\n\n  _onPeriodUpdate: function _onPeriodUpdate(field) {\n    var _this = this;\n\n    return function () {\n      var update = _utilObjectUtils2['default'].clone(_this.state.config);\n      var period = _this.refs[field].getValue().toUpperCase();\n\n      if (!period.startsWith('P')) {\n        period = 'P' + period;\n      }\n\n      update[field] = period;\n\n      _this.setState({ config: update });\n    };\n  },\n\n  _onChecked: function _onChecked() {\n    var config = _utilObjectUtils2['default'].clone(this.state.config);\n\n    if (this.state.limitEnabled) {\n      // If currently enabled, disable by setting the limit to 0 seconds.\n      config.query_time_range_limit = 'PT0S';\n    } else {\n      // If currently not enabled, set a default of 30 days.\n      config.query_time_range_limit = 'P30D';\n    }\n\n    this.setState({ config: config, limitEnabled: !this.state.limitEnabled });\n  },\n\n  _onTimerangeOptionRemove: function _onTimerangeOptionRemove(removedIdx) {\n    var _this2 = this;\n\n    return function () {\n      var options = _utilObjectUtils2['default'].clone(_this2.state.timerangeOptionsList);\n\n      // Remove element at index\n      options.splice(removedIdx, 1);\n\n      _this2._updateTimerangeOptionsState(options);\n    };\n  },\n\n  _onTimerangeOptionAdd: function _onTimerangeOptionAdd() {\n    var options = _utilObjectUtils2['default'].clone(this.state.timerangeOptionsList);\n\n    if (options) {\n      options.push({ period: 'PT1S', description: '' });\n      this._updateTimerangeOptionsState(options);\n    }\n  },\n\n  _onTimerangeOptionChange: function _onTimerangeOptionChange(changedIdx, field) {\n    var _this3 = this;\n\n    return function (e) {\n      var options = _utilObjectUtils2['default'].clone(_this3.state.timerangeOptionsList);\n\n      options.forEach(function (o, idx) {\n        if (idx === changedIdx) {\n          var value = e.target.value;\n\n          if (field === 'period') {\n            value = value.toUpperCase();\n            if (!value.startsWith('P')) {\n              value = 'P' + value;\n            }\n          }\n\n          options[idx][field] = value;\n        }\n      });\n\n      _this3._updateTimerangeOptionsState(options);\n    };\n  },\n\n  _isEnabled: function _isEnabled() {\n    return this.state.limitEnabled;\n  },\n\n  _saveConfig: function _saveConfig() {\n    var _this4 = this;\n\n    this.props.updateConfig(this.state.config).then(function () {\n      _this4._closeModal();\n    });\n  },\n\n  _resetConfig: function _resetConfig() {\n    // Reset to initial state when the modal is closed without saving.\n    this.setState(this.getInitialState());\n  },\n\n  _openModal: function _openModal() {\n    this.refs.searchesConfigModal.open();\n  },\n\n  _closeModal: function _closeModal() {\n    this.refs.searchesConfigModal.close();\n  },\n\n  render: function render() {\n    var _this5 = this;\n\n    var config = this.state.config;\n    var duration = _moment2['default'].duration(config.query_time_range_limit);\n    var limit = this._isEnabled() ? config.query_time_range_limit + ' (' + duration.format() + ')' : 'disabled';\n\n    var timerangeOptions = null;\n    var timerangeOptionsSummary = null;\n    if (this.state.timerangeOptionsList) {\n      timerangeOptions = this.state.timerangeOptionsList.map(function (option, idx) {\n        var period = option.period;\n        var description = option.description;\n\n        return _react2['default'].createElement(\n          'div',\n          { key: 'timerange-option-' + idx },\n          _react2['default'].createElement(\n            _reactBootstrap.Row,\n            null,\n            _react2['default'].createElement(\n              _reactBootstrap.Col,\n              { xs: 4 },\n              _react2['default'].createElement(\n                'div',\n                { className: 'input-group' },\n                _react2['default'].createElement('input', { type: 'text',\n                  className: 'form-control',\n                  value: period,\n                  onChange: _this5._onTimerangeOptionChange(idx, 'period') }),\n                _react2['default'].createElement(\n                  'span',\n                  { className: 'input-group-addon' },\n                  _moment2['default'].duration(period).format()\n                )\n              )\n            ),\n            _react2['default'].createElement(\n              _reactBootstrap.Col,\n              { xs: 8 },\n              _react2['default'].createElement(\n                'div',\n                { className: 'input-group' },\n                _react2['default'].createElement('input', { type: 'text',\n                  className: 'form-control',\n                  placeholder: 'Add description...',\n                  value: description,\n                  onChange: _this5._onTimerangeOptionChange(idx, 'description') }),\n                _react2['default'].createElement(\n                  'span',\n                  { className: 'input-group-addon' },\n                  _react2['default'].createElement('i', { className: 'fa fa-trash', style: { cursor: 'pointer' }, onClick: _this5._onTimerangeOptionRemove(idx) })\n                )\n              )\n            )\n          )\n        );\n      });\n      timerangeOptionsSummary = this.state.timerangeOptionsList.map(function (option, idx) {\n        var period = option.period;\n        var description = option.description;\n\n        return _react2['default'].createElement(\n          'span',\n          { key: 'timerange-options-summary-' + idx },\n          _react2['default'].createElement(\n            'dt',\n            null,\n            period\n          ),\n          _react2['default'].createElement(\n            'dd',\n            null,\n            description\n          )\n        );\n      });\n    }\n\n    return _react2['default'].createElement(\n      'div',\n      null,\n      _react2['default'].createElement(\n        'h2',\n        null,\n        'Search Configuration'\n      ),\n      _react2['default'].createElement(\n        'dl',\n        { className: _styleCssComponentsConfigurationsConfigurationStylesCss2['default'].deflist },\n        _react2['default'].createElement(\n          'dt',\n          null,\n          'Query time range limit'\n        ),\n        _react2['default'].createElement(\n          'dd',\n          null,\n          limit\n        ),\n        _react2['default'].createElement(\n          'dd',\n          null,\n          'The maximum time users can query data in the past. This prevents users from accidentally creating queries which span a lot of data and would need a long time and many resources to complete (if at all).'\n        )\n      ),\n      _react2['default'].createElement(\n        'strong',\n        null,\n        'Relative time range options'\n      ),\n      _react2['default'].createElement(\n        'dl',\n        { className: _styleCssComponentsConfigurationsConfigurationStylesCss2['default'].deflist },\n        timerangeOptionsSummary\n      ),\n      _react2['default'].createElement(\n        _componentsCommon.IfPermitted,\n        { permissions: 'clusterconfigentry:edit' },\n        _react2['default'].createElement(\n          _reactBootstrap.Button,\n          { bsStyle: 'info', bsSize: 'xs', onClick: this._openModal },\n          'Update'\n        )\n      ),\n      _react2['default'].createElement(\n        _componentsBootstrapBootstrapModalForm2['default'],\n        { ref: 'searchesConfigModal',\n          title: 'Update Search Configuration',\n          onSubmitForm: this._saveConfig,\n          onModalClose: this._resetConfig,\n          submitButtonText: 'Save' },\n        _react2['default'].createElement(\n          'fieldset',\n          null,\n          _react2['default'].createElement(_reactBootstrap.Input, { type: 'checkbox', label: 'Enable query limit',\n            name: 'enabled',\n            checked: this._isEnabled(),\n            onChange: this._onChecked }),\n          this._isEnabled() && _react2['default'].createElement(_reactBootstrap.Input, { type: 'text',\n            ref: 'query_time_range_limit',\n            label: 'Query time range limit (ISO8601 Duration)',\n            onChange: this._onPeriodUpdate('query_time_range_limit'),\n            value: config.query_time_range_limit,\n            help: 'The maximum time range for searches. (i.e. \"P30D\" for 30 days, \"PT24H\" for 24 hours)',\n            addonAfter: this._formatDuration(this.state.config.query_time_range_limit),\n            bsStyle: this._validationState(),\n            required: true }),\n          _react2['default'].createElement(\n            'div',\n            { className: 'form-group' },\n            _react2['default'].createElement(\n              'label',\n              { className: 'control-label' },\n              'Relative Timerange Options'\n            ),\n            _react2['default'].createElement(\n              'span',\n              { className: 'help-block' },\n              'Configure the available options for the ',\n              _react2['default'].createElement(\n                'strong',\n                null,\n                'relative'\n              ),\n              ' time range selector as ',\n              _react2['default'].createElement(\n                'strong',\n                null,\n                'ISO8601 duration'\n              ),\n              '.'\n            ),\n            _react2['default'].createElement(\n              'div',\n              { className: 'wrapper' },\n              timerangeOptions\n            ),\n            _react2['default'].createElement(\n              _reactBootstrap.Button,\n              { bsSize: 'xs', onClick: this._onTimerangeOptionAdd },\n              'Add option'\n            )\n          )\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = SearchesConfig;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"SearchesConfig.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/configurations/SearchesConfig.jsx\n ** module id = 650\n ** module chunks = 29\n **/\n//# sourceURL=webpack:///./src/components/configurations/SearchesConfig.jsx?")},779:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(3);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _componentsCommon = __webpack_require__(4);\n\nvar _storesConfigurationsConfigurationsStore = __webpack_require__(372);\n\nvar _storesConfigurationsConfigurationsStore2 = _interopRequireDefault(_storesConfigurationsConfigurationsStore);\n\nvar _actionsConfigurationsConfigurationActions = __webpack_require__(192);\n\nvar _actionsConfigurationsConfigurationActions2 = _interopRequireDefault(_actionsConfigurationsConfigurationActions);\n\nvar _componentsConfigurationsSearchesConfig = __webpack_require__(650);\n\nvar _componentsConfigurationsSearchesConfig2 = _interopRequireDefault(_componentsConfigurationsSearchesConfig);\n\nvar ConfigurationsPage = _react2['default'].createClass({\n  displayName: 'ConfigurationsPage',\n\n  mixins: [_reflux2['default'].connect(_storesConfigurationsConfigurationsStore2['default'])],\n\n  getInitialState: function getInitialState() {\n    return {\n      configuration: null\n    };\n  },\n\n  componentDidMount: function componentDidMount() {\n    _actionsConfigurationsConfigurationActions2['default'].list(this.SEARCHES_CLUSTER_CONFIG);\n  },\n\n  SEARCHES_CLUSTER_CONFIG: 'org.graylog2.indexer.searches.SearchesClusterConfig',\n\n  _getConfig: function _getConfig(configType) {\n    if (this.state.configuration && this.state.configuration[configType]) {\n      return this.state.configuration[configType];\n    } else {\n      return null;\n    }\n  },\n\n  _onUpdate: function _onUpdate(configType) {\n    return function (config) {\n      return _actionsConfigurationsConfigurationActions2['default'].update(configType, config);\n    };\n  },\n\n  render: function render() {\n    var searchesConfig = this._getConfig(this.SEARCHES_CLUSTER_CONFIG);\n    var searchesConfigComponent = undefined;\n    if (searchesConfig) {\n      searchesConfigComponent = _react2['default'].createElement(_componentsConfigurationsSearchesConfig2['default'], { config: searchesConfig,\n        updateConfig: this._onUpdate(this.SEARCHES_CLUSTER_CONFIG) });\n    } else {\n      searchesConfigComponent = _react2['default'].createElement(_componentsCommon.Spinner, null);\n    }\n\n    return _react2['default'].createElement(\n      'span',\n      null,\n      _react2['default'].createElement(\n        _componentsCommon.PageHeader,\n        { title: 'Configurations' },\n        _react2['default'].createElement(\n          'span',\n          null,\n          'You can configure system settings for different sub systems on this page.'\n        )\n      ),\n      _react2['default'].createElement(\n        _reactBootstrap.Row,\n        { className: 'content' },\n        _react2['default'].createElement(\n          _reactBootstrap.Col,\n          { md: 12 },\n          searchesConfigComponent\n        )\n      )\n    );\n  }\n});\n\nexports['default'] = ConfigurationsPage;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"ConfigurationsPage.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/react-hot-loader!./~/babel-loader!./src/pages/ConfigurationsPage.jsx\n ** module id = 779\n ** module chunks = 29\n **/\n//# sourceURL=webpack:///./src/pages/ConfigurationsPage.jsx?./~/react-hot-loader!./~/babel-loader");
},922:function(module,exports,__webpack_require__){eval("// style-loader: Adds some css to the DOM by adding a <style> tag\n\n// load the styles\nvar content = __webpack_require__(434);\nif(typeof content === 'string') content = [[module.id, content, '']];\n// add the styles to the DOM\nvar update = __webpack_require__(27)(content, {});\nif(content.locals) module.exports = content.locals;\n// Hot Module Replacement\nif(false) {\n	// When the styles change, update the <style> tags\n	if(!content.locals) {\n		module.hot.accept(\"!!./../../../node_modules/css-loader/index.js!./ConfigurationStyles.css\", function() {\n			var newContent = require(\"!!./../../../node_modules/css-loader/index.js!./ConfigurationStyles.css\");\n			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];\n			update(newContent);\n		});\n	}\n	// When the module is disposed, remove the <style> tags\n	module.hot.dispose(function() { update(); });\n}\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/style-loader!./~/css-loader!./src/components/configurations/ConfigurationStyles.css\n ** module id = 922\n ** module chunks = 29\n **/\n//# sourceURL=webpack:///./src/components/configurations/ConfigurationStyles.css?./~/style-loader!./~/css-loader")}});