/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackException;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.streams.Stream;

public class HTTPAlarmCallback
implements AlarmCallback {
    private static final String CK_URL = "url";
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private Configuration configuration;

    @Inject
    public HTTPAlarmCallback(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public void initialize(Configuration config) throws AlarmCallbackConfigurationException {
        this.configuration = config;
    }

    @Override
    public void call(Stream stream, AlertCondition.CheckResult result) throws AlarmCallbackException {
        byte[] body;
        HashMap event = Maps.newHashMap();
        event.put("stream", stream);
        event.put("check_result", result);
        try {
            body = this.objectMapper.writeValueAsBytes((Object)event);
        }
        catch (JsonProcessingException e) {
            throw new AlarmCallbackException("Unable to serialize alarm", e);
        }
        String url = this.configuration.getString(CK_URL);
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new AlarmCallbackException("Malformed URL: " + url);
        }
        Request request = new Request.Builder().url(httpUrl).post(RequestBody.create((MediaType)CONTENT_TYPE, (byte[])body)).build();
        try (Response r = this.httpClient.newCall(request).execute();){
            if (!r.isSuccessful()) {
                throw new AlarmCallbackException("Expected successful HTTP response [2xx] but got [" + r.code() + "].");
            }
        }
        catch (IOException e) {
            throw new AlarmCallbackException(e.getMessage(), e);
        }
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest configurationRequest = new ConfigurationRequest();
        configurationRequest.addField(new TextField(CK_URL, "URL", "https://example.org/alerts", "The URL to POST to when an alert is triggered", ConfigurationField.Optional.NOT_OPTIONAL));
        return configurationRequest;
    }

    @Override
    public String getName() {
        return "HTTP Alarm Callback";
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.configuration.getSource();
    }

    @Override
    public void checkConfiguration() throws ConfigurationException {
        String url = this.configuration.getString(CK_URL);
        if (Strings.isNullOrEmpty((String)url)) {
            throw new ConfigurationException("URL parameter is missing!");
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Malformed URL", e);
        }
    }
}

