/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;

public class AlertConditionFactory {
    private final Map<String, AlertCondition.Factory> alertConditionMap;

    @Inject
    public AlertConditionFactory(Map<String, AlertCondition.Factory> alertConditionMap) {
        this.alertConditionMap = alertConditionMap;
    }

    public AlertCondition createAlertCondition(String type, Stream stream, String id, DateTime createdAt, String creatorId, Map<String, Object> parameters, String title) {
        AlertCondition.Factory factory = this.alertConditionMap.get(type);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)("Unknown alert condition type: " + type));
        return factory.create(stream, id, createdAt, creatorId, parameters, title);
    }
}

