/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IndexHelper.class);

    public static Set<String> getOldestIndices(Set<String> indexNames, int count) {
        HashSet r = Sets.newHashSet();
        if (count < 0 || indexNames.size() <= count) {
            return r;
        }
        HashSet numbers = Sets.newHashSet();
        for (String indexName : indexNames) {
            numbers.add(Deflector.extractIndexNumber(indexName));
        }
        List<String> sorted = IndexHelper.prependPrefixes(IndexHelper.getPrefix(indexNames), Tools.asSortedList(numbers));
        r.addAll(sorted.subList(0, count));
        return r;
    }

    public static QueryBuilder getTimestampRangeFilter(TimeRange range) throws InvalidRangeFormatException {
        if (range == null) {
            return null;
        }
        return QueryBuilders.rangeQuery((String)"timestamp").gte(Tools.buildElasticSearchTimeFormat(range.getFrom())).lte(Tools.buildElasticSearchTimeFormat(range.getTo()));
    }

    private static String getPrefix(Set<String> names) {
        if (names.isEmpty()) {
            return "";
        }
        String name = (String)names.toArray()[0];
        return name.substring(0, name.lastIndexOf("_"));
    }

    public static List<String> prependPrefixes(String prefix, List<Integer> numbers) {
        ArrayList r = Lists.newArrayList();
        for (int number : numbers) {
            r.add(prefix + "_" + number);
        }
        return r;
    }

    public static Set<String> determineAffectedIndices(IndexRangeService indexRangeService, TimeRange range) {
        Set<IndexRange> indexRanges = IndexHelper.determineAffectedIndicesWithRanges(indexRangeService, range);
        ImmutableSet.Builder indices = ImmutableSet.builder();
        for (IndexRange indexRange : indexRanges) {
            indices.add((Object)indexRange.indexName());
        }
        return indices.build();
    }

    public static Set<IndexRange> determineAffectedIndicesWithRanges(IndexRangeService indexRangeService, TimeRange range) {
        ImmutableSortedSet.Builder indices = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        for (IndexRange indexRange : indexRangeService.find(range.getFrom(), range.getTo())) {
            indices.add((Object)indexRange);
        }
        return indices.build();
    }
}

