/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.esplugin.ClusterStateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Cluster {
    private static final Logger LOG = LoggerFactory.getLogger(Cluster.class);
    private final Client c;
    private final IndexSetRegistry indexSetRegistry;
    private final ScheduledExecutorService scheduler;
    private final Duration requestTimeout;
    private final AtomicReference<Map<String, DiscoveryNode>> nodes = new AtomicReference();

    @Inject
    public Cluster(Client client, IndexSetRegistry indexSetRegistry, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, @Named(value="elasticsearch_request_timeout") Duration requestTimeout) {
        this.scheduler = scheduler;
        this.c = client;
        this.indexSetRegistry = indexSetRegistry;
        this.requestTimeout = requestTimeout;
        ClusterStateMonitor.setCluster(this);
    }

    public ClusterHealthResponse health() {
        ClusterHealthRequest request = new ClusterHealthRequest(this.indexSetRegistry.getWriteIndexWildcards());
        return (ClusterHealthResponse)this.c.admin().cluster().health(request).actionGet();
    }

    public ClusterHealthResponse deflectorHealth() {
        ClusterHealthRequest request = new ClusterHealthRequest(this.indexSetRegistry.getWriteIndexNames());
        return (ClusterHealthResponse)this.c.admin().cluster().health(request).actionGet();
    }

    public Map<String, NodeInfo> getDataNodes() {
        return this.getAllNodes().entrySet().stream().filter(n -> ((NodeInfo)n.getValue()).getSettings().getAsBoolean("node.data", Boolean.valueOf(true))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, NodeInfo> getAllNodes() {
        ClusterAdminClient clusterAdminClient = this.c.admin().cluster();
        NodesInfoRequest request = (NodesInfoRequest)clusterAdminClient.prepareNodesInfo(new String[0]).all().request();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NodeInfo nodeInfo : (NodeInfo[])((NodesInfoResponse)clusterAdminClient.nodesInfo(request).actionGet()).getNodes()) {
            builder.put((Object)nodeInfo.getNode().id(), (Object)nodeInfo);
        }
        return builder.build();
    }

    public Map<String, NodeStats> getNodesStats(String ... nodesIds) {
        ClusterAdminClient clusterAdminClient = this.c.admin().cluster();
        NodesStatsRequest request = (NodesStatsRequest)clusterAdminClient.prepareNodesStats(nodesIds).request();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (NodeStats nodeStats : (NodeStats[])((NodesStatsResponse)clusterAdminClient.nodesStats(request).actionGet()).getNodes()) {
            builder.put((Object)nodeStats.getNode().id(), (Object)nodeStats);
        }
        return builder.build();
    }

    public String nodeIdToName(String nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId);
        return nodeInfo == null ? "UNKNOWN" : nodeInfo.getNode().getName();
    }

    public String nodeIdToHostName(String nodeId) {
        NodeInfo nodeInfo = this.getNodeInfo(nodeId);
        return nodeInfo == null ? "UNKNOWN" : nodeInfo.getHostname();
    }

    private NodeInfo getNodeInfo(String nodeId) {
        if (nodeId == null || nodeId.isEmpty()) {
            return null;
        }
        try {
            NodesInfoResponse r = (NodesInfoResponse)this.c.admin().cluster().nodesInfo(new NodesInfoRequest(new String[]{nodeId}).all()).actionGet();
            return (NodeInfo)r.getNodesMap().get(nodeId);
        }
        catch (Exception e) {
            LOG.error("Could not read name of ES node.", (Throwable)e);
            return null;
        }
    }

    public boolean isConnected() {
        Map<String, DiscoveryNode> nodeMap = this.nodes.get();
        return nodeMap != null && !nodeMap.isEmpty();
    }

    public boolean isHealthy() {
        try {
            return this.health().getStatus() != ClusterHealthStatus.RED && this.indexSetRegistry.isUp();
        }
        catch (ElasticsearchException e) {
            LOG.trace("Couldn't determine Elasticsearch health properly", (Throwable)e);
            return false;
        }
    }

    public boolean isDeflectorHealthy() {
        try {
            return this.deflectorHealth().getStatus() != ClusterHealthStatus.RED && this.indexSetRegistry.isUp();
        }
        catch (ElasticsearchException e) {
            LOG.trace("Couldn't determine deflector index health properly", (Throwable)e);
            return false;
        }
    }

    public void waitForConnectedAndDeflectorHealthy(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        LOG.debug("Waiting until the write-active index is healthy again, checking once per second.");
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                if (this.isConnected() && this.isDeflectorHealthy()) {
                    LOG.debug("Write-active index is healthy again, unblocking waiting threads.");
                    latch.countDown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        boolean waitSuccess = latch.await(timeout, unit);
        scheduledFuture.cancel(true);
        if (!waitSuccess) {
            throw new TimeoutException("Write-active index didn't get healthy within timeout");
        }
    }

    public void waitForConnectedAndDeflectorHealthy() throws InterruptedException, TimeoutException {
        this.waitForConnectedAndDeflectorHealthy(this.requestTimeout.getQuantity(), this.requestTimeout.getUnit());
    }

    public void updateDataNodeList(Map<String, DiscoveryNode> nodes) {
        LOG.debug("{} data nodes in cluster", (Object)nodes.size());
        this.nodes.set(nodes);
    }
}

