/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.indexer.indexset.AutoValue_IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.hibernate.validator.constraints.NotBlank;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonAutoDetect
public abstract class IndexSetConfig {
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty(value="title")
    @NotBlank
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @JsonProperty(value="index_prefix")
    @NotBlank
    public abstract String indexPrefix();

    @JsonProperty(value="shards")
    @Min(value=1L)
    public abstract int shards();

    @JsonProperty(value="replicas")
    @Min(value=0L)
    public abstract int replicas();

    @JsonProperty(value="rotation_strategy")
    @NotNull
    public abstract RotationStrategyConfig rotationStrategy();

    @JsonProperty(value="retention_strategy")
    @NotNull
    public abstract RetentionStrategyConfig retentionStrategy();

    @JsonProperty(value="creation_date")
    @NotNull
    public abstract ZonedDateTime creationDate();

    @JsonCreator
    public static IndexSetConfig create(@Id @ObjectId @JsonProperty(value="_id") @Nullable String id, @JsonProperty(value="title") @NotBlank String title, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="index_prefix") @NotBlank String indexPrefix, @JsonProperty(value="shards") @Min(value=1L) int shards, @JsonProperty(value="replicas") @Min(value=0L) int replicas, @JsonProperty(value="rotation_strategy") @NotNull RotationStrategyConfig rotationStrategy, @JsonProperty(value="retention_strategy") @NotNull RetentionStrategyConfig retentionStrategy, @JsonProperty(value="creation_date") @NotNull ZonedDateTime creationDate) {
        return AutoValue_IndexSetConfig.builder().id(id).title(title).description(description).indexPrefix(indexPrefix).shards(shards).replicas(replicas).rotationStrategy(rotationStrategy).retentionStrategy(retentionStrategy).creationDate(creationDate).build();
    }

    public static IndexSetConfig create(String title, String description, String indexPrefix, int shards, int replicas, RotationStrategyConfig rotationStrategy, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate) {
        return IndexSetConfig.create(null, title, description, indexPrefix, shards, replicas, rotationStrategy, retentionStrategy, creationDate);
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_IndexSetConfig.Builder();
    }

    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder title(String var1);

        public abstract Builder description(String var1);

        public abstract Builder indexPrefix(String var1);

        public abstract Builder shards(int var1);

        public abstract Builder replicas(int var1);

        public abstract Builder rotationStrategy(RotationStrategyConfig var1);

        public abstract Builder retentionStrategy(RetentionStrategyConfig var1);

        public abstract Builder creationDate(ZonedDateTime var1);

        public abstract IndexSetConfig build();
    }
}

