/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.mongodb.DBCollection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.events.IndexSetCreatedEvent;
import org.graylog2.indexer.indexset.events.IndexSetDeletedEvent;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class MongoIndexSetService
implements IndexSetService {
    private static final String COLLECTION_NAME = "index_sets";
    private final JacksonDBCollection<IndexSetConfig, ObjectId> collection;
    private final ClusterEventBus clusterEventBus;

    @Inject
    public MongoIndexSetService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider, ClusterEventBus clusterEventBus) {
        this((JacksonDBCollection<IndexSetConfig, ObjectId>)JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), IndexSetConfig.class, ObjectId.class, (ObjectMapper)objectMapperProvider.get()), clusterEventBus);
    }

    @VisibleForTesting
    protected MongoIndexSetService(JacksonDBCollection<IndexSetConfig, ObjectId> collection, ClusterEventBus clusterEventBus) {
        this.collection = Objects.requireNonNull(collection);
        this.clusterEventBus = Objects.requireNonNull(clusterEventBus);
    }

    @Override
    public Optional<IndexSetConfig> get(String id) {
        return this.get(new ObjectId(id));
    }

    @Override
    public Optional<IndexSetConfig> get(ObjectId id) {
        DBQuery.Query query = DBQuery.is((String)"_id", (Object)id);
        IndexSetConfig indexSetConfig = (IndexSetConfig)this.collection.findOne(query);
        return Optional.ofNullable(indexSetConfig);
    }

    @Override
    public Set<IndexSetConfig> findAll() {
        return ImmutableSet.copyOf((Iterator)this.collection.find());
    }

    @Override
    public IndexSetConfig save(IndexSetConfig indexSetConfig) {
        WriteResult writeResult = this.collection.save((Object)indexSetConfig);
        IndexSetConfig savedObject = (IndexSetConfig)writeResult.getSavedObject();
        IndexSetCreatedEvent createdEvent = IndexSetCreatedEvent.create(savedObject);
        this.clusterEventBus.post(createdEvent);
        return savedObject;
    }

    @Override
    public int delete(String id) {
        return this.delete(new ObjectId(id));
    }

    @Override
    public int delete(ObjectId id) {
        DBQuery.Query query = DBQuery.is((String)"_id", (Object)id);
        WriteResult writeResult = this.collection.remove(query);
        int removedEntries = writeResult.getN();
        if (removedEntries > 0) {
            IndexSetDeletedEvent deletedEvent = IndexSetDeletedEvent.create(id.toHexString());
            this.clusterEventBus.post(deletedEvent);
        }
        return removedEntries;
    }
}

