/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.jobs;

import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.SetIndexReadOnlyJob;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.system.jobs.SystemJob;

public class SetIndexReadOnlyAndCalculateRangeJob
extends SystemJob {
    private final SetIndexReadOnlyJob.Factory setIndexReadOnlyJobFactory;
    private final CreateNewSingleIndexRangeJob.Factory createNewSingleIndexRangeJobFactory;
    private final IndexSetRegistry indexSetRegistry;
    private final String indexName;

    @Inject
    public SetIndexReadOnlyAndCalculateRangeJob(SetIndexReadOnlyJob.Factory setIndexReadOnlyJobFactory, CreateNewSingleIndexRangeJob.Factory createNewSingleIndexRangeJobFactory, IndexSetRegistry indexSetRegistry, @Assisted String indexName) {
        this.setIndexReadOnlyJobFactory = setIndexReadOnlyJobFactory;
        this.createNewSingleIndexRangeJobFactory = createNewSingleIndexRangeJobFactory;
        this.indexSetRegistry = indexSetRegistry;
        this.indexName = indexName;
    }

    @Override
    public void execute() {
        SetIndexReadOnlyJob setIndexReadOnlyJob = this.setIndexReadOnlyJobFactory.create(this.indexName);
        ((SystemJob)setIndexReadOnlyJob).execute();
        CreateNewSingleIndexRangeJob createNewSingleIndexRangeJob = this.createNewSingleIndexRangeJobFactory.create(this.indexSetRegistry, this.indexName);
        ((SystemJob)createNewSingleIndexRangeJob).execute();
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int maxConcurrency() {
        return 1000;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Makes index " + this.indexName + " read only and calculates and adds its index range afterwards.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public SetIndexReadOnlyAndCalculateRangeJob create(String var1);
    }
}

