/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.graylog2.indexer.results.ResultMessage;

public class IndexQueryResult {
    private final String originalQuery;
    private final TimeValue took;
    private final BytesReference builtQuery;

    public IndexQueryResult(String originalQuery, BytesReference builtQuery, TimeValue took) {
        this.originalQuery = originalQuery;
        this.took = took;
        this.builtQuery = builtQuery;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public String getBuiltQuery() {
        try {
            return XContentHelper.convertToJson((BytesReference)this.builtQuery, (boolean)false);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public TimeValue took() {
        return this.took;
    }

    protected List<ResultMessage> buildResults(SearchHits hits) {
        ArrayList r = Lists.newArrayList();
        for (SearchHit hit : hits) {
            r.add(ResultMessage.parseFromSource(hit));
        }
        return r;
    }
}

