/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import org.graylog2.inputs.transports.AmqpConsumer;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransport
extends ThrottleableTransport {
    public static final String CK_HOSTNAME = "broker_hostname";
    public static final String CK_PORT = "broker_port";
    public static final String CK_VHOST = "broker_vhost";
    public static final String CK_USERNAME = "broker_username";
    public static final String CK_PASSWORD = "broker_password";
    public static final String CK_PREFETCH = "prefetch";
    public static final String CK_EXCHANGE = "exchange";
    public static final String CK_EXCHANGE_BIND = "exchange_bind";
    public static final String CK_QUEUE = "queue";
    public static final String CK_ROUTING_KEY = "routing_key";
    public static final String CK_PARALLEL_QUEUES = "parallel_queues";
    public static final String CK_TLS = "tls";
    public static final String CK_REQUEUE_INVALID_MESSAGES = "requeue_invalid_messages";
    public static final String CK_HEARTBEAT_TIMEOUT = "heartbeat";
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransport.class);
    private final Configuration configuration;
    private final EventBus eventBus;
    private final MetricRegistry localRegistry;
    private final ScheduledExecutorService scheduler;
    private AmqpConsumer consumer;

    @AssistedInject
    public AmqpTransport(@Assisted Configuration configuration, EventBus eventBus, LocalMetricRegistry localRegistry, @Named(value="daemonScheduler") ScheduledExecutorService scheduler) {
        super(eventBus, configuration);
        this.configuration = configuration;
        this.eventBus = eventBus;
        this.localRegistry = localRegistry;
        this.scheduler = scheduler;
        localRegistry.register("read_bytes_1sec", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return AmqpTransport.this.consumer.getLastSecBytesRead().get();
            }
        });
        localRegistry.register("written_bytes_1sec", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return 0L;
            }
        });
        localRegistry.register("read_bytes_total", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return AmqpTransport.this.consumer.getTotalBytesRead().get();
            }
        });
        localRegistry.register("written_bytes_total", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return 0L;
            }
        });
    }

    @Subscribe
    public void lifecycleChanged(Lifecycle lifecycle) {
        try {
            LOG.debug("Lifecycle changed to {}", (Object)lifecycle);
            switch (lifecycle) {
                case PAUSED: 
                case FAILED: 
                case HALTING: {
                    try {
                        if (this.consumer != null) {
                            this.consumer.stop();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to stop consumer", (Throwable)e);
                    }
                    break;
                }
                default: {
                    if (this.consumer.isConnected()) {
                        LOG.debug("Consumer is already connected, not running it a second time.");
                        break;
                    }
                    try {
                        this.consumer.run();
                        break;
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to resume consumer", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.warn("This should not throw any exceptions", (Throwable)e);
        }
    }

    @Override
    public void setMessageAggregator(CodecAggregator aggregator) {
    }

    @Override
    public void doLaunch(MessageInput input) throws MisfireException {
        int heartbeatTimeout = 60;
        if (this.configuration.intIsSet(CK_HEARTBEAT_TIMEOUT) && (heartbeatTimeout = this.configuration.getInt(CK_HEARTBEAT_TIMEOUT)) < 0) {
            LOG.warn("AMQP heartbeat interval must not be negative ({}), using default timeout ({}).", (Object)heartbeatTimeout, (Object)60);
            heartbeatTimeout = 60;
        }
        this.consumer = new AmqpConsumer(this.configuration.getString(CK_HOSTNAME), this.configuration.getInt(CK_PORT), this.configuration.getString(CK_VHOST), this.configuration.getString(CK_USERNAME), this.configuration.getString(CK_PASSWORD), this.configuration.getInt(CK_PREFETCH), this.configuration.getString(CK_QUEUE), this.configuration.getString(CK_EXCHANGE), this.configuration.getBoolean(CK_EXCHANGE_BIND), this.configuration.getString(CK_ROUTING_KEY), this.configuration.getInt(CK_PARALLEL_QUEUES), this.configuration.getBoolean(CK_TLS), this.configuration.getBoolean(CK_REQUEUE_INVALID_MESSAGES), heartbeatTimeout, input, this.scheduler, this);
        this.eventBus.register((Object)this);
        try {
            this.consumer.run();
        }
        catch (IOException e) {
            this.eventBus.unregister((Object)this);
            throw new MisfireException("Could not launch AMQP consumer.", e);
        }
    }

    @Override
    public void doStop() {
        if (this.consumer != null) {
            try {
                this.consumer.stop();
            }
            catch (IOException e) {
                LOG.error("Could not stop AMQP consumer.", (Throwable)e);
            }
        }
        this.eventBus.unregister((Object)this);
    }

    @Override
    public MetricSet getMetricSet() {
        return this.localRegistry;
    }

    @ConfigClass
    public static class Config
    extends ThrottleableTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest cr = super.getRequestedConfiguration();
            cr.addField(new TextField(AmqpTransport.CK_HOSTNAME, "Broker hostname", "", "Hostname of the AMQP broker to use", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new NumberField(AmqpTransport.CK_PORT, "Broker port", (Number)5672, "Port of the AMQP broker to use", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.IS_PORT_NUMBER));
            cr.addField(new TextField(AmqpTransport.CK_VHOST, "Broker virtual host", "/", "Virtual host of the AMQP broker to use", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new TextField(AmqpTransport.CK_USERNAME, "Username", "", "Username to connect to AMQP broker", ConfigurationField.Optional.OPTIONAL));
            cr.addField(new TextField(AmqpTransport.CK_PASSWORD, "Password", "", "Password to connect to AMQP broker", ConfigurationField.Optional.OPTIONAL, TextField.Attribute.IS_PASSWORD));
            cr.addField(new NumberField(AmqpTransport.CK_PREFETCH, "Prefetch count", (Number)100, "For advanced usage: AMQP prefetch count. Default is 100.", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new TextField(AmqpTransport.CK_QUEUE, "Queue", this.defaultQueueName(), "Name of queue that is created.", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new TextField(AmqpTransport.CK_EXCHANGE, "Exchange", this.defaultExchangeName(), "Name of exchange to bind to.", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new BooleanField(AmqpTransport.CK_EXCHANGE_BIND, "Bind to exchange", false, "Binds the queue to the configured exchange. The exchange must already exist."));
            cr.addField(new TextField(AmqpTransport.CK_ROUTING_KEY, "Routing key", this.defaultRoutingKey(), "Routing key to listen for.", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new NumberField(AmqpTransport.CK_PARALLEL_QUEUES, "Number of Queues", (Number)1, "Number of parallel Queues", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new NumberField(AmqpTransport.CK_HEARTBEAT_TIMEOUT, "Heartbeat timeout", (Number)60, "Heartbeat interval in seconds (use 0 to disable heartbeat)", ConfigurationField.Optional.OPTIONAL));
            cr.addField(new BooleanField(AmqpTransport.CK_TLS, "Enable TLS?", false, "Enable transport encryption via TLS. (requires valid TLS port setting)"));
            cr.addField(new BooleanField(AmqpTransport.CK_REQUEUE_INVALID_MESSAGES, "Re-queue invalid messages?", true, "Invalid messages will be discarded if disabled."));
            return cr;
        }

        protected String defaultRoutingKey() {
            return "#";
        }

        protected String defaultExchangeName() {
            return "log-messages";
        }

        protected String defaultQueueName() {
            return "log-messages";
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<AmqpTransport> {
        @Override
        public AmqpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

