/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchOutput
implements MessageOutput {
    private static final String WRITES_METRICNAME = MetricRegistry.name(ElasticSearchOutput.class, (String[])new String[]{"writes"});
    private static final String PROCESS_TIME_METRICNAME = MetricRegistry.name(ElasticSearchOutput.class, (String[])new String[]{"processTime"});
    private static final String NAME = "ElasticSearch Output";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchOutput.class);
    private final Meter writes;
    private final Timer processTime;
    private final Messages messages;
    private final Journal journal;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    @AssistedInject
    public ElasticSearchOutput(MetricRegistry metricRegistry, Messages messages, Journal journal, @Assisted Stream stream, @Assisted Configuration configuration) {
        this(metricRegistry, messages, journal);
    }

    @Inject
    public ElasticSearchOutput(MetricRegistry metricRegistry, Messages messages, Journal journal) {
        this.messages = messages;
        this.journal = journal;
        this.writes = metricRegistry.meter(WRITES_METRICNAME);
        this.processTime = metricRegistry.timer(PROCESS_TIME_METRICNAME);
        this.isRunning.set(true);
    }

    @Override
    public void write(Message message) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing message id to [{}]: <{}>", (Object)NAME, (Object)message.getId());
        }
        this.write(Collections.singletonList(message));
    }

    @Override
    public void write(List<Message> messageList) throws Exception {
        if (LOG.isTraceEnabled()) {
            List sortedIds = Ordering.natural().sortedCopy((Iterable)Lists.transform(messageList, Message.ID_FUNCTION));
            LOG.trace("Writing message ids to [{}]: <{}>", (Object)NAME, (Object)Joiner.on((String)", ").join((Iterable)sortedIds));
        }
        this.writes.mark((long)messageList.size());
        try (Timer.Context ignored = this.processTime.time();){
            this.messages.bulkIndex(messageList);
        }
        for (Message message : messageList) {
            this.journal.markJournalOffsetCommitted(message.getJournalOffset());
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public static class Descriptor
    extends MessageOutput.Descriptor {
        public Descriptor() {
            super("Elasticsearch Output", false, "", "Elasticsearch Output");
        }

        public Descriptor(String name, boolean exclusive, String linkToDocs, String humanName) {
            super(name, exclusive, linkToDocs, humanName);
        }
    }

    public static class Config
    extends MessageOutput.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return new ConfigurationRequest();
        }
    }

    public static interface Factory
    extends MessageOutput.Factory<ElasticSearchOutput> {
        @Override
        public ElasticSearchOutput create(Stream var1, Configuration var2);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

