/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.TooManyAliasesException;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRotationThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRotationThread.class);
    private NotificationService notificationService;
    private final IndexSetRegistry indexSetRegistry;
    private final Cluster cluster;
    private final ActivityWriter activityWriter;
    private final Indices indices;
    private final NodeId nodeId;
    private final ClusterConfigService clusterConfigService;
    private final Map<String, Provider<RotationStrategy>> rotationStrategyMap;

    @Inject
    public IndexRotationThread(NotificationService notificationService, Indices indices, IndexSetRegistry indexSetRegistry, Cluster cluster, ActivityWriter activityWriter, NodeId nodeId, ClusterConfigService clusterConfigService, Map<String, Provider<RotationStrategy>> rotationStrategyMap) {
        this.notificationService = notificationService;
        this.indexSetRegistry = indexSetRegistry;
        this.cluster = cluster;
        this.activityWriter = activityWriter;
        this.indices = indices;
        this.nodeId = nodeId;
        this.clusterConfigService = clusterConfigService;
        this.rotationStrategyMap = rotationStrategyMap;
    }

    @Override
    public void doRun() {
        if (this.cluster.isConnected()) {
            this.indexSetRegistry.forEach(indexSet -> {
                try {
                    this.checkAndRepair((IndexSet)indexSet);
                    this.checkForRotation((IndexSet)indexSet);
                }
                catch (Exception e) {
                    LOG.error("Couldn't point deflector to a new index", (Throwable)e);
                }
            });
        } else {
            LOG.debug("Elasticsearch cluster isn't healthy. Skipping index rotation.");
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    protected void checkForRotation(IndexSet indexSet) {
        IndexManagementConfig config = this.clusterConfigService.get(IndexManagementConfig.class);
        if (config == null) {
            LOG.warn("No index management configuration found, not running index rotation!");
            this.rotationProblemNotification("Index Rotation Problem!", "No index management configuration found, not running index rotation! Please fix your index rotation configuration!");
            return;
        }
        Provider<RotationStrategy> rotationStrategyProvider = this.rotationStrategyMap.get(config.rotationStrategy());
        if (rotationStrategyProvider == null) {
            LOG.warn("Rotation strategy \"{}\" not found, not running index rotation!", (Object)config.rotationStrategy());
            this.rotationProblemNotification("Index Rotation Problem!", "Index rotation strategy " + config.rotationStrategy() + " not found! Please fix your index rotation configuration!");
            return;
        }
        RotationStrategy rotationStrategy = (RotationStrategy)rotationStrategyProvider.get();
        if (rotationStrategy == null) {
            LOG.warn("No rotation strategy found, not running index rotation!");
            return;
        }
        rotationStrategy.rotate(indexSet);
    }

    private void rotationProblemNotification(String title, String description) {
        Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.URGENT).addDetail("title", title).addDetail("description", description);
        this.notificationService.publishIfFirst(notification);
    }

    protected void checkAndRepair(IndexSet indexSet) {
        if (!indexSet.isUp()) {
            if (this.indices.exists(indexSet.getWriteIndexAlias())) {
                Notification notification = this.notificationService.buildNow().addType(Notification.Type.DEFLECTOR_EXISTS_AS_INDEX).addSeverity(Notification.Severity.URGENT);
                boolean published = this.notificationService.publishIfFirst(notification);
                if (published) {
                    LOG.warn("There is an index called [" + indexSet.getWriteIndexAlias() + "]. Cannot fix this automatically and published a notification.");
                }
            } else {
                indexSet.setUp();
            }
        } else {
            try {
                String currentTarget;
                try {
                    currentTarget = indexSet.getCurrentActualTargetIndex();
                }
                catch (TooManyAliasesException e) {
                    indexSet.cleanupAliases(e.getIndices());
                    try {
                        currentTarget = indexSet.getCurrentActualTargetIndex();
                    }
                    catch (TooManyAliasesException e1) {
                        throw new IllegalStateException(e1);
                    }
                }
                String shouldBeTarget = indexSet.getNewestTargetName();
                if (!shouldBeTarget.equals(currentTarget)) {
                    String msg = "Deflector is pointing to [" + currentTarget + "], not the newest one: [" + shouldBeTarget + "]. Re-pointing.";
                    LOG.warn(msg);
                    this.activityWriter.write(new Activity(msg, IndexRotationThread.class));
                    if (ClusterHealthStatus.RED == this.indices.waitForRecovery(shouldBeTarget)) {
                        LOG.error("New target index for deflector didn't get healthy within timeout. Skipping deflector update.");
                    } else {
                        indexSet.pointTo(shouldBeTarget, currentTarget);
                    }
                }
            }
            catch (NoTargetIndexException e) {
                LOG.warn("Deflector is not up. Not trying to point to another index.");
            }
        }
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 10;
    }
}

