/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alarmcallbacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alarmcallbacks.AlarmCallbackHistory;
import org.graylog2.alarmcallbacks.AlarmCallbackHistoryService;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertService;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackHistoryListSummary;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackHistorySummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="AlarmCallbackHistories", description="Manage stream alarm callback histories")
@Path(value="/streams/{streamid}/alerts/{alertId}/history")
public class AlarmCallbackHistoryResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmCallbackHistoryResource.class);
    private final AlarmCallbackHistoryService alarmCallbackHistoryService;
    private final StreamService streamService;
    private final AlertService alertService;

    @Inject
    public AlarmCallbackHistoryResource(AlarmCallbackHistoryService alarmCallbackHistoryService, StreamService streamService, AlertService alertService) {
        this.alarmCallbackHistoryService = alarmCallbackHistoryService;
        this.streamService = streamService;
        this.alertService = alertService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all alarm callbacks for this stream")
    @Produces(value={"application/json"})
    public AlarmCallbackHistoryListSummary getForAlert(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks history we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alertId", value="The id of the alert whose callback history we want.", required=true) @PathParam(value="alertId") String alertId) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        Alert alert = this.alertService.load(alertId, streamid);
        List<AlarmCallbackHistory> historyList = this.alarmCallbackHistoryService.getForAlertId(alertId);
        ArrayList historySummaryList = Lists.newArrayListWithCapacity((int)historyList.size());
        for (AlarmCallbackHistory alarmCallbackHistory : historyList) {
            historySummaryList.add(AlarmCallbackHistorySummary.create(alarmCallbackHistory.id(), alarmCallbackHistory.alarmcallbackConfiguration(), alarmCallbackHistory.alertId(), alarmCallbackHistory.alertConditionId(), alarmCallbackHistory.result(), alarmCallbackHistory.createdAt()));
        }
        return AlarmCallbackHistoryListSummary.create(historySummaryList);
    }
}

