/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetResponse;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetSummary;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/IndexSets", description="Index sets")
@Path(value="/system/indices/index_sets")
@Produces(value={"application/json"})
public class IndexSetsResource
extends RestResource {
    private final IndexSetService indexSetService;

    @Inject
    public IndexSetsResource(IndexSetService indexSetService) {
        this.indexSetService = Objects.requireNonNull(indexSetService);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all index sets")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    public IndexSetResponse list() {
        Set<IndexSetSummary> indexSets = this.indexSetService.findAll().stream().filter(indexSetConfig -> this.isPermitted("indexsets:read", indexSetConfig.id())).map(IndexSetSummary::fromIndexSetConfig).collect(Collectors.toSet());
        return IndexSetResponse.create(indexSets.size(), indexSets);
    }

    @GET
    @Path(value="{id}")
    @Timed
    @ApiOperation(value="Get index set")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized"), @ApiResponse(code=404, message="Index set not found")})
    public IndexSetSummary get(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        this.checkPermission("indexsets:read", id);
        return this.indexSetService.get(id).map(IndexSetSummary::fromIndexSetConfig).orElseThrow(() -> new NotFoundException("Couldn't load index set with ID <" + id + ">"));
    }

    @POST
    @Timed
    @ApiOperation(value="Create index set")
    @RequiresPermissions(value={"indexsets:create"})
    @Consumes(value={"application/json"})
    @AuditEvent(type="server:index_set:create")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized")})
    public IndexSetSummary save(@ApiParam(name="Index set configuration", required=true) @Valid @NotNull IndexSetSummary indexSet) {
        IndexSetConfig savedObject = this.indexSetService.save(indexSet.toIndexSetConfig());
        return IndexSetSummary.fromIndexSetConfig(savedObject);
    }

    @PUT
    @Path(value="{id}")
    @Timed
    @ApiOperation(value="Update index set")
    @AuditEvent(type="server:index_set:update")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized"), @ApiResponse(code=409, message="Mismatch of IDs in URI path and payload")})
    public IndexSetSummary update(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="Index set configuration", required=true) @Valid @NotNull IndexSetSummary indexSet) {
        this.checkPermission("indexsets:edit", id);
        if (indexSet.id() != null && !id.equals(indexSet.id())) {
            throw new ClientErrorException("Mismatch of IDs in URI path and payload", Response.Status.CONFLICT);
        }
        IndexSetConfig savedObject = this.indexSetService.save(indexSet.toIndexSetConfig());
        return IndexSetSummary.fromIndexSetConfig(savedObject);
    }

    @DELETE
    @Path(value="{id}")
    @Timed
    @ApiOperation(value="Delete index set")
    @AuditEvent(type="server:index_set:delete")
    @ApiResponses(value={@ApiResponse(code=403, message="Unauthorized"), @ApiResponse(code=404, message="Index set not found")})
    public void delete(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        this.checkPermission("indexsets:delete", id);
        if (this.indexSetService.delete(id) == 0) {
            throw new NotFoundException("Couldn't delete index set with ID <" + id + ">");
        }
    }
}

