/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertConditionFactory;
import org.graylog2.alerts.AlertImpl;
import org.graylog2.alerts.AlertService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.streams.alerts.requests.CreateConditionRequest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;

public class AlertServiceImpl
implements AlertService {
    private final JacksonDBCollection<AlertImpl, String> coll;
    private final AlertConditionFactory alertConditionFactory;

    @Inject
    public AlertServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider, AlertConditionFactory alertConditionFactory) {
        this.alertConditionFactory = alertConditionFactory;
        String collectionName = AlertImpl.class.getAnnotation(CollectionName.class).value();
        DBCollection dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)dbCollection, AlertImpl.class, String.class, (ObjectMapper)mapperProvider.get());
    }

    @Override
    public Alert.Builder builder() {
        return AlertImpl.builder().id(new ObjectId().toHexString());
    }

    @Override
    public Alert factory(AlertCondition.CheckResult checkResult) {
        Preconditions.checkArgument((boolean)checkResult.isTriggered(), (Object)"Unable to create alert for CheckResult which is not triggered.");
        return this.builder().streamId(checkResult.getTriggeredCondition().getStream().getId()).conditionId(checkResult.getTriggeredCondition().getId()).description(checkResult.getResultDescription()).conditionParameters((Map<String, Object>)ImmutableMap.copyOf(checkResult.getTriggeredCondition().getParameters())).triggeredAt(checkResult.getTriggeredAt()).build();
    }

    @Override
    public List<Alert> loadRecentOfStream(String streamId, DateTime since, int limit) {
        return Collections.unmodifiableList(this.coll.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"stream_id", (Object)streamId), DBQuery.greaterThanEquals((String)"triggered_at", (Object)since)})).limit(limit).sort((DBObject)DBSort.desc((String)"triggered_at")).toArray());
    }

    @Override
    public int triggeredSecondsAgo(String streamId, String conditionId) {
        List mostRecentAlerts = this.coll.find(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"stream_id", (Object)streamId), DBQuery.is((String)"condition_id", (Object)conditionId)})).sort((DBObject)DBSort.desc((String)"triggered_at")).limit(1).toArray();
        if (mostRecentAlerts == null || mostRecentAlerts.size() == 0) {
            return -1;
        }
        Alert mostRecentAlert = (Alert)mostRecentAlerts.get(0);
        return Seconds.secondsBetween((ReadableInstant)mostRecentAlert.getTriggeredAt(), (ReadableInstant)Tools.nowUTC()).getSeconds();
    }

    @Override
    public long totalCount() {
        return this.coll.count();
    }

    @Override
    public long totalCountForStream(String streamId) {
        return this.coll.count((DBObject)new BasicDBObject("stream_id", (Object)streamId));
    }

    @Override
    public AlertCondition fromPersisted(Map<String, Object> fields, Stream stream) {
        String type = (String)fields.get("type");
        return this.alertConditionFactory.createAlertCondition(type, stream, (String)fields.get("id"), DateTime.parse((String)((String)fields.get("created_at"))), (String)fields.get("creator_user_id"), (Map)fields.get("parameters"), (String)fields.get("title"));
    }

    @Override
    public AlertCondition fromRequest(CreateConditionRequest ccr, Stream stream, String userId) {
        String type = ccr.type();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Missing alert condition type");
        return this.alertConditionFactory.createAlertCondition(type, stream, null, Tools.nowUTC(), userId, ccr.parameters(), ccr.title());
    }

    @Override
    public AlertCondition updateFromRequest(AlertCondition alertCondition, CreateConditionRequest ccr) {
        ImmutableMap parameters = ImmutableMap.builder().putAll(alertCondition.getParameters()).putAll(ccr.parameters()).build();
        return this.alertConditionFactory.createAlertCondition(alertCondition.getType(), alertCondition.getStream(), alertCondition.getId(), alertCondition.getCreatedAt(), alertCondition.getCreatorUserId(), (Map<String, Object>)parameters, ccr.title());
    }

    @Override
    public boolean inGracePeriod(AlertCondition alertCondition) {
        int lastAlertSecondsAgo = this.triggeredSecondsAgo(alertCondition.getStream().getId(), alertCondition.getId());
        if (lastAlertSecondsAgo == -1 || alertCondition.getGrace() == 0) {
            return false;
        }
        return lastAlertSecondsAgo < alertCondition.getGrace() * 60;
    }

    @Override
    public List<Alert> listForStreamId(String streamId, int skip, int limit) {
        return Collections.unmodifiableList(this.coll.find(DBQuery.is((String)"stream_id", (Object)streamId)).sort((DBObject)DBSort.desc((String)"triggered_at")).skip(skip).limit(limit).toArray());
    }

    @Override
    public Alert load(String alertId, String streamId) throws NotFoundException {
        return (Alert)this.coll.findOneById((Object)alertId);
    }

    @Override
    public String save(Alert alert) throws ValidationException {
        Preconditions.checkArgument((boolean)(alert instanceof AlertImpl), (Object)("Supplied argument must be of type " + AlertImpl.class + ", and not " + alert.getClass()));
        return (String)this.coll.save((Object)((AlertImpl)alert)).getSavedId();
    }
}

