/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts.types;

import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.indexer.InvalidRangeFormatException;
import org.graylog2.indexer.results.CountResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.SearchResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCountAlertCondition
extends AbstractAlertCondition {
    private static final Logger LOG = LoggerFactory.getLogger(MessageCountAlertCondition.class);
    private final int time;
    private final ThresholdType thresholdType;
    private final int threshold;
    private final Searches searches;

    @AssistedInject
    public MessageCountAlertCondition(Searches searches, @Assisted Stream stream, @Nullable @Assisted(value="id") String id, @Assisted DateTime createdAt, @Assisted(value="userid") String creatorUserId, @Assisted Map<String, Object> parameters, @Nullable @Assisted(value="title") String title) {
        super(stream, id, AbstractAlertCondition.Type.MESSAGE_COUNT.toString(), createdAt, creatorUserId, parameters, title);
        this.searches = searches;
        this.time = this.getNumber(parameters.get("time")).orElse(0).intValue();
        this.thresholdType = ThresholdType.valueOf(((String)parameters.get("threshold_type")).toUpperCase(Locale.ENGLISH));
        this.threshold = this.getNumber(parameters.get("threshold")).orElse(0).intValue();
    }

    @Override
    public String getDescription() {
        return "time: " + this.time + ", threshold_type: " + this.thresholdType.toString().toLowerCase(Locale.ENGLISH) + ", threshold: " + this.threshold + ", grace: " + this.grace;
    }

    @Override
    public AbstractAlertCondition.CheckResult runCheck() {
        try {
            boolean triggered;
            RelativeRange relativeRange = RelativeRange.create(this.time * 60);
            AbsoluteRange range = AbsoluteRange.create(relativeRange.getFrom(), relativeRange.getTo());
            String filter = "streams:" + this.stream.getId();
            CountResult result = this.searches.count("*", range, filter);
            long count = result.count();
            LOG.debug("Alert check <{}> result: [{}]", (Object)this.id, (Object)count);
            switch (this.thresholdType) {
                case MORE: {
                    triggered = count > (long)this.threshold;
                    break;
                }
                case LESS: {
                    triggered = count < (long)this.threshold;
                    break;
                }
                default: {
                    triggered = false;
                }
            }
            if (triggered) {
                ArrayList summaries = Lists.newArrayList();
                if (this.getBacklog() > 0) {
                    SearchResult backlogResult = this.searches.search("*", filter, range, this.getBacklog(), 0, new Sorting("timestamp", Sorting.Direction.DESC));
                    for (ResultMessage resultMessage : backlogResult.getResults()) {
                        Message msg = resultMessage.getMessage();
                        summaries.add(new MessageSummary(resultMessage.getIndex(), msg));
                    }
                }
                String resultDescription = "Stream had " + count + " messages in the last " + this.time + " minutes with trigger condition " + this.thresholdType.toString().toLowerCase(Locale.ENGLISH) + " than " + this.threshold + " messages. " + "(Current grace time: " + this.grace + " minutes)";
                return new AbstractAlertCondition.CheckResult(true, this, resultDescription, Tools.nowUTC(), summaries);
            }
            return new AbstractAlertCondition.NegativeCheckResult();
        }
        catch (InvalidRangeParametersException e) {
            LOG.error("Invalid timerange.", (Throwable)e);
            return null;
        }
        catch (InvalidRangeFormatException e) {
            LOG.error("Invalid timerange format.", (Throwable)e);
            return null;
        }
    }

    public static class Descriptor
    extends AlertCondition.Descriptor {
        public Descriptor() {
            super("Message Count Alert Condition", "https://www.graylog.org/", "This condition is triggered when the number of messages in a defined time interval is higher or lower a defined threshold.");
        }
    }

    public static class Config
    implements AlertCondition.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return ConfigurationRequest.createWithFields(new NumberField("time", "Time Range", (Number)0, "Time span in seconds to check", ConfigurationField.Optional.NOT_OPTIONAL), new NumberField("threshold", "Threshold", (Number)0.0, "Value which triggers an alert if crossed", ConfigurationField.Optional.NOT_OPTIONAL), new DropdownField("threshold_type", "Threshold Type", ThresholdType.MORE.toString(), Arrays.stream(ThresholdType.values()).collect(Collectors.toMap(Enum::toString, ThresholdType::getDescription)), ConfigurationField.Optional.NOT_OPTIONAL)).addFields(AbstractAlertCondition.getDefaultConfigurationFields());
        }
    }

    public static interface Factory
    extends AlertCondition.Factory {
        @Override
        public MessageCountAlertCondition create(Stream var1, @Assisted(value="id") String var2, DateTime var3, @Assisted(value="userid") String var4, Map<String, Object> var5, @Assisted(value="title") @Nullable String var6);

        @Override
        public Config config();

        @Override
        public Descriptor descriptor();
    }

    static enum ThresholdType {
        MORE("more than"),
        LESS("less than");

        private final String description;

        private ThresholdType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

