/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.elasticsearch.client.Client;
import org.elasticsearch.node.Node;
import org.graylog2.indexer.elasticsearch.GlobalTimeoutClient;

@Singleton
public class EsClientProvider
implements Provider<Client> {
    private final Node node;
    private final MetricRegistry metricRegistry;
    private final Duration requestTimeout;

    @Inject
    public EsClientProvider(Node node, MetricRegistry metricRegistry, @Named(value="elasticsearch_request_timeout") Duration requestTimeout) {
        this.node = node;
        this.metricRegistry = metricRegistry;
        this.requestTimeout = requestTimeout;
    }

    public Client get() {
        return new GlobalTimeoutClient(this.node.client(), this.requestTimeout.getQuantity(), this.requestTimeout.getUnit(), this.metricRegistry);
    }
}

