/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import javax.inject.Inject;
import javax.inject.Provider;
import org.mongojack.internal.MongoJackModule;

public class MongoJackObjectMapperProvider
implements Provider<ObjectMapper> {
    private final ObjectMapper objectMapper;

    @Inject
    public MongoJackObjectMapperProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.copy().setPropertyNamingStrategy((PropertyNamingStrategy)new PreserveLeadingUnderscoreStrategy());
        MongoJackModule.configure((ObjectMapper)this.objectMapper);
    }

    public ObjectMapper get() {
        return this.objectMapper;
    }

    public static class PreserveLeadingUnderscoreStrategy
    extends PropertyNamingStrategy.SnakeCaseStrategy {
        public String translate(String input) {
            String translated = super.translate(input);
            if (input.startsWith("_") && !translated.startsWith("_")) {
                translated = "_" + translated;
            }
            return translated;
        }
    }
}

