/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bundles;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.bundles.ConfigurationBundle;
import org.graylog2.bundles.Converter;
import org.graylog2.bundles.Dashboard;
import org.graylog2.bundles.DashboardWidget;
import org.graylog2.bundles.ExportBundle;
import org.graylog2.bundles.Extractor;
import org.graylog2.bundles.GrokPattern;
import org.graylog2.bundles.Input;
import org.graylog2.bundles.Output;
import org.graylog2.bundles.Stream;
import org.graylog2.bundles.StreamRule;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.widgets.DashboardWidgetCreator;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleExporter {
    private static final Logger LOG = LoggerFactory.getLogger(BundleExporter.class);
    private final InputService inputService;
    private final StreamService streamService;
    private final OutputService outputService;
    private final DashboardService dashboardService;
    private final DashboardWidgetCreator dashboardWidgetCreator;
    private final GrokPatternService grokPatternService;
    private Set<String> streamSet = new HashSet<String>();

    @Inject
    public BundleExporter(InputService inputService, StreamService streamService, OutputService outputService, DashboardService dashboardService, DashboardWidgetCreator dashboardWidgetCreator, GrokPatternService grokPatternService) {
        this.inputService = inputService;
        this.streamService = streamService;
        this.outputService = outputService;
        this.dashboardService = dashboardService;
        this.dashboardWidgetCreator = dashboardWidgetCreator;
        this.grokPatternService = grokPatternService;
    }

    public ConfigurationBundle export(ExportBundle exportBundle) {
        ConfigurationBundle configurationBundle = new ConfigurationBundle();
        this.streamSet = new HashSet<String>(exportBundle.getStreams());
        Set<Dashboard> dashboards = this.exportDashboards(exportBundle.getDashboards());
        Set<Output> outputs = this.exportOutputs(exportBundle.getOutputs());
        Set<Stream> streams = this.exportStreams(this.streamSet);
        Set<GrokPattern> grokPatterns = this.exportGrokPatterns(exportBundle.getGrokPatterns());
        Set<Input> inputs = this.exportInputs(exportBundle.getInputs());
        configurationBundle.setName(exportBundle.getName());
        configurationBundle.setCategory(exportBundle.getCategory());
        configurationBundle.setDescription(exportBundle.getDescription());
        configurationBundle.setGrokPatterns(grokPatterns);
        configurationBundle.setInputs(inputs);
        configurationBundle.setStreams(streams);
        configurationBundle.setOutputs(outputs);
        configurationBundle.setDashboards(dashboards);
        return configurationBundle;
    }

    private Set<GrokPattern> exportGrokPatterns(Set<String> grokPatterns) {
        ImmutableSet.Builder grokPatternBuilder = ImmutableSet.builder();
        for (String name : grokPatterns) {
            GrokPattern grokPattern = this.exportGrokPattern(name);
            if (grokPattern == null) continue;
            grokPatternBuilder.add((Object)grokPattern);
        }
        return grokPatternBuilder.build();
    }

    private GrokPattern exportGrokPattern(String grokPatternName) {
        org.graylog2.grok.GrokPattern grokPattern;
        try {
            grokPattern = this.grokPatternService.load(grokPatternName);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested grok pattern \"{}\" not found.", (Object)grokPatternName);
            return null;
        }
        return GrokPattern.create(grokPattern.name(), grokPattern.pattern());
    }

    private Set<Input> exportInputs(Set<String> inputs) {
        ImmutableSet.Builder inputBuilder = ImmutableSet.builder();
        for (String inputId : inputs) {
            Input input = this.exportInput(inputId);
            if (input == null) continue;
            inputBuilder.add((Object)input);
        }
        return inputBuilder.build();
    }

    private Input exportInput(String inputId) {
        org.graylog2.inputs.Input input;
        try {
            input = this.inputService.find(inputId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested input {} not found.", (Object)inputId);
            return null;
        }
        Input inputDescription = new Input();
        inputDescription.setTitle(input.getTitle());
        inputDescription.setType(input.getType());
        inputDescription.setGlobal(input.isGlobal());
        inputDescription.setConfiguration(input.getConfiguration());
        inputDescription.setStaticFields(input.getStaticFields());
        inputDescription.setExtractors(this.exportExtractors(input));
        return inputDescription;
    }

    private List<Extractor> exportExtractors(org.graylog2.inputs.Input input) {
        ImmutableList.Builder extractorBuilder = ImmutableList.builder();
        List<org.graylog2.plugin.inputs.Extractor> extractors = this.inputService.getExtractors(input);
        for (org.graylog2.plugin.inputs.Extractor extractor : extractors) {
            extractorBuilder.add((Object)this.exportExtractor(extractor));
        }
        return extractorBuilder.build();
    }

    private Extractor exportExtractor(org.graylog2.plugin.inputs.Extractor extractor) {
        Extractor extractorDescription = new Extractor();
        extractorDescription.setTitle(extractor.getTitle());
        extractorDescription.setType(extractor.getType());
        extractorDescription.setConfiguration(extractor.getExtractorConfig());
        extractorDescription.setConditionType(extractor.getConditionType());
        extractorDescription.setConditionValue(extractor.getConditionValue());
        extractorDescription.setCursorStrategy(extractor.getCursorStrategy());
        extractorDescription.setOrder(extractor.getOrder().intValue());
        extractorDescription.setSourceField(extractor.getSourceField());
        extractorDescription.setTargetField(extractor.getTargetField());
        List<org.graylog2.plugin.inputs.Converter> converters = extractor.getConverters();
        extractorDescription.setConverters(this.exportConverters(converters));
        return extractorDescription;
    }

    private List<Converter> exportConverters(List<org.graylog2.plugin.inputs.Converter> converters) {
        ImmutableList.Builder converterBuilder = ImmutableList.builder();
        for (org.graylog2.plugin.inputs.Converter converter : converters) {
            Converter converterDescription = new Converter();
            Converter.Type type = Converter.Type.valueOf(converter.getType().toUpperCase(Locale.ENGLISH));
            converterDescription.setType(type);
            converterDescription.setConfiguration(converter.getConfig());
            converterBuilder.add((Object)converterDescription);
        }
        return converterBuilder.build();
    }

    private Set<Stream> exportStreams(Set<String> streams) {
        ImmutableSet.Builder streamBuilder = ImmutableSet.builder();
        for (String streamId : streams) {
            Stream stream = this.exportStream(streamId);
            if (stream == null) continue;
            streamBuilder.add((Object)stream);
        }
        return streamBuilder.build();
    }

    private Stream exportStream(String streamId) {
        org.graylog2.plugin.streams.Stream stream;
        try {
            stream = this.streamService.load(streamId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested stream {} not found.", (Object)streamId);
            return null;
        }
        Stream streamDescription = new Stream();
        streamDescription.setId(stream.getId());
        streamDescription.setTitle(stream.getTitle());
        streamDescription.setDescription(stream.getDescription());
        streamDescription.setDisabled(stream.getDisabled());
        streamDescription.setMatchingType(stream.getMatchingType());
        streamDescription.setOutputs(this.exportOutputReferences(stream.getOutputs()));
        streamDescription.setStreamRules(this.exportStreamRules(stream.getStreamRules()));
        streamDescription.setDefaultStream(stream.isDefaultStream());
        return streamDescription;
    }

    private List<StreamRule> exportStreamRules(List<org.graylog2.plugin.streams.StreamRule> streamRules) {
        ImmutableList.Builder streamRuleBuilder = ImmutableList.builder();
        for (org.graylog2.plugin.streams.StreamRule streamRule : streamRules) {
            StreamRule streamRuleDescription = new StreamRule();
            streamRuleDescription.setType(streamRule.getType());
            streamRuleDescription.setField(streamRule.getField());
            streamRuleDescription.setValue(streamRule.getValue());
            streamRuleDescription.setInverted(streamRule.getInverted());
            streamRuleDescription.setDescription(streamRule.getDescription());
            streamRuleBuilder.add((Object)streamRuleDescription);
        }
        return streamRuleBuilder.build();
    }

    private Set<String> exportOutputReferences(Set<org.graylog2.plugin.streams.Output> outputs) {
        ImmutableSet.Builder outputBuilder = ImmutableSet.builder();
        for (org.graylog2.plugin.streams.Output output : outputs) {
            outputBuilder.add((Object)output.getId());
        }
        return outputBuilder.build();
    }

    private Set<Output> exportOutputs(Set<String> outputs) {
        ImmutableSet.Builder outputBuilder = ImmutableSet.builder();
        for (String outputId : outputs) {
            Output output = this.exportOutput(outputId);
            if (output == null) continue;
            outputBuilder.add((Object)output);
        }
        return outputBuilder.build();
    }

    private Output exportOutput(String outputId) {
        org.graylog2.plugin.streams.Output output;
        try {
            output = this.outputService.load(outputId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested output {} not found.", (Object)outputId);
            return null;
        }
        Output outputDescription = new Output();
        outputDescription.setId(output.getId());
        outputDescription.setTitle(output.getTitle());
        outputDescription.setType(output.getType());
        outputDescription.setConfiguration(output.getConfiguration());
        return outputDescription;
    }

    private Set<Dashboard> exportDashboards(Set<String> dashboards) {
        ImmutableSet.Builder dashboardBuilder = ImmutableSet.builder();
        for (String dashboardId : dashboards) {
            Dashboard dashboard = this.exportDashboard(dashboardId);
            if (dashboard == null) continue;
            dashboardBuilder.add((Object)dashboard);
        }
        return dashboardBuilder.build();
    }

    private Dashboard exportDashboard(String dashboardId) {
        org.graylog2.dashboards.Dashboard dashboard;
        try {
            dashboard = this.dashboardService.load(dashboardId);
        }
        catch (NotFoundException e) {
            LOG.debug("Requested dashboard {} not found.", (Object)dashboardId);
            return null;
        }
        Dashboard dashboardDescription = new Dashboard();
        dashboardDescription.setTitle(dashboard.getTitle());
        dashboardDescription.setDescription(dashboard.getDescription());
        dashboardDescription.setDashboardWidgets(this.exportDashboardWidgets(dashboard));
        return dashboardDescription;
    }

    private List<DashboardWidget> exportDashboardWidgets(org.graylog2.dashboards.Dashboard dashboard) {
        ImmutableList.Builder dashboardWidgetBuilder = ImmutableList.builder();
        Map<String, Object> fields = dashboard.getFields();
        Map positions = (Map)dashboard.asMap().get("positions");
        if (fields.containsKey("widgets")) {
            for (BasicDBObject widgetFields : (List)fields.get("widgets")) {
                Map widgetPosition;
                org.graylog2.dashboards.widgets.DashboardWidget widget;
                try {
                    widget = this.dashboardWidgetCreator.fromPersisted(widgetFields);
                }
                catch (Exception e) {
                    LOG.warn("Error while exporting widgets of dashboard " + dashboard.getId(), (Throwable)e);
                    continue;
                }
                DashboardWidget dashboardWidgetDescription = new DashboardWidget();
                Map<String, Object> widgetConfig = widget.getConfig();
                dashboardWidgetDescription.setDescription(widget.getDescription());
                dashboardWidgetDescription.setType(widget.getType());
                dashboardWidgetDescription.setConfiguration(widgetConfig);
                dashboardWidgetDescription.setCacheTime(widget.getCacheTime());
                Object streamId = widgetConfig.get("stream_id");
                if (streamId instanceof String && this.streamSet.add((String)streamId)) {
                    LOG.debug("Adding stream {} to export list", streamId);
                }
                if ((widgetPosition = (Map)positions.get(widget.getId())) != null) {
                    Integer row = (Integer)widgetPosition.get("row");
                    Integer col = (Integer)widgetPosition.get("col");
                    Integer height = (Integer)widgetPosition.get("height");
                    Integer width = (Integer)widgetPosition.get("width");
                    dashboardWidgetDescription.setRow(row == null ? 0 : row);
                    dashboardWidgetDescription.setCol(col == null ? 0 : col);
                    dashboardWidgetDescription.setHeight(height == null ? 0 : height);
                    dashboardWidgetDescription.setWidth(width == null ? 0 : width);
                } else {
                    LOG.debug("Couldn't find position for widget {} on dashboard {}, using defaults (0, 0, 0, 0).", (Object)widget.getId(), (Object)dashboard.getTitle());
                    dashboardWidgetDescription.setRow(0);
                    dashboardWidgetDescription.setCol(0);
                    dashboardWidgetDescription.setHeight(0);
                    dashboardWidgetDescription.setWidth(0);
                }
                dashboardWidgetBuilder.add((Object)dashboardWidgetDescription);
            }
        }
        return dashboardWidgetBuilder.build();
    }
}

