/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indices.TooManyAliasesException;

public class LegacyDeflectorIndexSet
implements IndexSet {
    private final Deflector deflector;

    @Inject
    public LegacyDeflectorIndexSet(Deflector deflector) {
        this.deflector = deflector;
    }

    @Override
    public String[] getManagedIndicesNames() {
        return this.deflector.getAllGraylogIndexNames();
    }

    @Override
    public String getWriteIndexAlias() {
        return this.deflector.getName();
    }

    @Override
    public String getWriteIndexWildcard() {
        return this.deflector.getDeflectorWildcard();
    }

    @Override
    public String getNewestTargetName() throws NoTargetIndexException {
        return this.deflector.getNewestTargetName();
    }

    @Override
    public String getCurrentActualTargetIndex() throws TooManyAliasesException {
        return this.deflector.getCurrentActualTargetIndex();
    }

    @Override
    public Map<String, Set<String>> getAllDeflectorAliases() {
        return this.deflector.getAllGraylogDeflectorIndices();
    }

    @Override
    public boolean isUp() {
        return this.deflector.isUp();
    }

    @Override
    public boolean isDeflectorAlias(String index) {
        return this.deflector.getName().equals(index);
    }

    @Override
    public boolean isManagedIndex(String index) {
        return this.deflector.isGraylogIndex(index);
    }

    @Override
    public void setUp() {
        this.deflector.setUp();
    }

    @Override
    public void cycle() {
        this.deflector.cycle();
    }

    @Override
    public void cleanupAliases(Set<String> indices) {
        this.deflector.cleanupAliases(indices);
    }

    @Override
    public void pointTo(String shouldBeTarget, String currentTarget) {
        this.deflector.pointTo(shouldBeTarget, currentTarget);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexPrefix", (Object)this.deflector.getName()).toString();
    }
}

