/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indices.TooManyAliasesException;

public class LegacyDeflectorRegistry
implements IndexSetRegistry {
    private final IndexSet indexSet;

    @Inject
    public LegacyDeflectorRegistry(IndexSet indexSet) {
        this.indexSet = Objects.requireNonNull(indexSet);
    }

    @Override
    public Set<IndexSet> getAllIndexSets() {
        return Collections.singleton(this.indexSet);
    }

    @Override
    public Iterator<IndexSet> iterator() {
        return Iterators.singletonIterator((Object)this.indexSet);
    }

    @Override
    public void forEach(Consumer<? super IndexSet> action) {
        action.accept(this.indexSet);
    }

    @Override
    public Spliterator<IndexSet> spliterator() {
        return Spliterators.spliterator(this.iterator(), 1L, 1344);
    }

    @Override
    public String[] getManagedIndicesNames() {
        return this.indexSet.getManagedIndicesNames();
    }

    @Override
    public boolean isManagedIndex(String indexName) {
        return this.indexSet.isManagedIndex(indexName);
    }

    @Override
    public String[] getWriteIndexWildcards() {
        return new String[]{this.indexSet.getWriteIndexWildcard()};
    }

    @Override
    public String[] getWriteIndexNames() {
        return new String[]{this.indexSet.getWriteIndexAlias()};
    }

    @Override
    public boolean isUp() {
        return this.indexSet.isUp();
    }

    @Override
    public boolean isCurrentWriteIndexAlias(String indexName) {
        return this.indexSet.isDeflectorAlias(indexName);
    }

    @Override
    public boolean isCurrentWriteIndex(String indexName) throws TooManyAliasesException {
        String currentWriteIndex = this.indexSet.getCurrentActualTargetIndex();
        return currentWriteIndex != null && currentWriteIndex.equals(indexName);
    }
}

