/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.hibernate.validator.constraints.NotBlank;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_IndexSetConfig
extends IndexSetConfig {
    private final String id;
    private final String title;
    private final String description;
    private final String indexPrefix;
    private final int shards;
    private final int replicas;
    private final RotationStrategyConfig rotationStrategy;
    private final RetentionStrategyConfig retentionStrategy;
    private final ZonedDateTime creationDate;

    private AutoValue_IndexSetConfig(@Nullable String id, String title, @Nullable String description, String indexPrefix, int shards, int replicas, RotationStrategyConfig rotationStrategy, RetentionStrategyConfig retentionStrategy, ZonedDateTime creationDate) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.indexPrefix = indexPrefix;
        this.shards = shards;
        this.replicas = replicas;
        this.rotationStrategy = rotationStrategy;
        this.retentionStrategy = retentionStrategy;
        this.creationDate = creationDate;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    @NotBlank
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="index_prefix")
    @NotBlank
    public String indexPrefix() {
        return this.indexPrefix;
    }

    @Override
    @JsonProperty(value="shards")
    @Min(value=1L)
    public int shards() {
        return this.shards;
    }

    @Override
    @JsonProperty(value="replicas")
    @Min(value=0L)
    public int replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="rotation_strategy")
    @NotNull
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategy;
    }

    @Override
    @JsonProperty(value="retention_strategy")
    @NotNull
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategy;
    }

    @Override
    @JsonProperty(value="creation_date")
    @NotNull
    public ZonedDateTime creationDate() {
        return this.creationDate;
    }

    public String toString() {
        return "IndexSetConfig{id=" + this.id + ", " + "title=" + this.title + ", " + "description=" + this.description + ", " + "indexPrefix=" + this.indexPrefix + ", " + "shards=" + this.shards + ", " + "replicas=" + this.replicas + ", " + "rotationStrategy=" + this.rotationStrategy + ", " + "retentionStrategy=" + this.retentionStrategy + ", " + "creationDate=" + this.creationDate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexSetConfig) {
            IndexSetConfig that = (IndexSetConfig)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.title.equals(that.title()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && this.indexPrefix.equals(that.indexPrefix()) && this.shards == that.shards() && this.replicas == that.replicas() && this.rotationStrategy.equals(that.rotationStrategy()) && this.retentionStrategy.equals(that.retentionStrategy()) && this.creationDate.equals(that.creationDate());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.title.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.indexPrefix.hashCode();
        h *= 1000003;
        h ^= this.shards;
        h *= 1000003;
        h ^= this.replicas;
        h *= 1000003;
        h ^= this.rotationStrategy.hashCode();
        h *= 1000003;
        h ^= this.retentionStrategy.hashCode();
        h *= 1000003;
        return h ^= this.creationDate.hashCode();
    }

    @Override
    public IndexSetConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IndexSetConfig.Builder {
        private String id;
        private String title;
        private String description;
        private String indexPrefix;
        private Integer shards;
        private Integer replicas;
        private RotationStrategyConfig rotationStrategy;
        private RetentionStrategyConfig retentionStrategy;
        private ZonedDateTime creationDate;

        Builder() {
        }

        Builder(IndexSetConfig source) {
            this.id = source.id();
            this.title = source.title();
            this.description = source.description();
            this.indexPrefix = source.indexPrefix();
            this.shards = source.shards();
            this.replicas = source.replicas();
            this.rotationStrategy = source.rotationStrategy();
            this.retentionStrategy = source.retentionStrategy();
            this.creationDate = source.creationDate();
        }

        @Override
        public IndexSetConfig.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public IndexSetConfig.Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public IndexSetConfig.Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public IndexSetConfig.Builder indexPrefix(String indexPrefix) {
            this.indexPrefix = indexPrefix;
            return this;
        }

        @Override
        public IndexSetConfig.Builder shards(int shards) {
            this.shards = shards;
            return this;
        }

        @Override
        public IndexSetConfig.Builder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public IndexSetConfig.Builder rotationStrategy(RotationStrategyConfig rotationStrategy) {
            this.rotationStrategy = rotationStrategy;
            return this;
        }

        @Override
        public IndexSetConfig.Builder retentionStrategy(RetentionStrategyConfig retentionStrategy) {
            this.retentionStrategy = retentionStrategy;
            return this;
        }

        @Override
        public IndexSetConfig.Builder creationDate(ZonedDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public IndexSetConfig build() {
            String missing = "";
            if (this.title == null) {
                missing = missing + " title";
            }
            if (this.indexPrefix == null) {
                missing = missing + " indexPrefix";
            }
            if (this.shards == null) {
                missing = missing + " shards";
            }
            if (this.replicas == null) {
                missing = missing + " replicas";
            }
            if (this.rotationStrategy == null) {
                missing = missing + " rotationStrategy";
            }
            if (this.retentionStrategy == null) {
                missing = missing + " retentionStrategy";
            }
            if (this.creationDate == null) {
                missing = missing + " creationDate";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IndexSetConfig(this.id, this.title, this.description, this.indexPrefix, this.shards, this.replicas, this.rotationStrategy, this.retentionStrategy, this.creationDate);
        }
    }
}

