/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.indexer.ranges.AutoValue_MongoIndexRange;
import org.graylog2.indexer.ranges.IndexRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.Id;

@JsonAutoDetect
public abstract class MongoIndexRange
implements IndexRange {
    @Id
    @Nullable
    @JsonProperty(value="_id")
    public abstract ObjectId id();

    @Override
    @JsonProperty(value="index_name")
    public abstract String indexName();

    @Override
    public abstract DateTime begin();

    @Override
    public abstract DateTime end();

    @Override
    public abstract DateTime calculatedAt();

    @Override
    @JsonProperty(value="took_ms")
    public abstract int calculationDuration();

    @JsonProperty(value="begin")
    private long beginMillis() {
        return this.begin().getMillis();
    }

    @JsonProperty(value="end")
    private long endMillis() {
        return this.end().getMillis();
    }

    @JsonProperty(value="calculated_at")
    private long calculatedAtMillis() {
        return this.calculatedAt().getMillis();
    }

    public static MongoIndexRange create(ObjectId id, String indexName, DateTime begin, DateTime end, DateTime calculatedAt, int calculationDuration) {
        return new AutoValue_MongoIndexRange(id, indexName, begin, end, calculatedAt, calculationDuration);
    }

    @JsonCreator
    public static MongoIndexRange create(@JsonProperty(value="_id") @Id @Nullable ObjectId id, @JsonProperty(value="index_name") String indexName, @JsonProperty(value="begin") long beginMillis, @JsonProperty(value="end") long endMillis, @JsonProperty(value="calculated_at") long calculatedAtMillis, @JsonProperty(value="took_ms") int calculationDuration) {
        DateTime begin = new DateTime(beginMillis, DateTimeZone.UTC);
        DateTime end = new DateTime(endMillis, DateTimeZone.UTC);
        DateTime calculatedAt = new DateTime(calculatedAtMillis, DateTimeZone.UTC);
        return new AutoValue_MongoIndexRange(id, indexName, begin, end, calculatedAt, calculationDuration);
    }

    public static MongoIndexRange create(String indexName, DateTime begin, DateTime end, DateTime calculatedAt, int calculationDuration) {
        return MongoIndexRange.create(null, indexName, begin, end, calculatedAt, calculationDuration);
    }

    public static MongoIndexRange create(IndexRange indexRange) {
        return MongoIndexRange.create(indexRange.indexName(), indexRange.begin(), indexRange.end(), indexRange.calculatedAt(), indexRange.calculationDuration());
    }
}

