/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

public abstract class HistogramResult
extends IndexQueryResult {
    private AbsoluteRange boundaries;

    public HistogramResult(String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
    }

    public abstract Searches.DateHistogramInterval getInterval();

    public abstract Map getResults();

    public AbsoluteRange getHistogramBoundaries() {
        if (this.boundaries == null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonParser jp = mapper.getFactory().createParser(this.getBuiltQuery());
                JsonNode rootNode = (JsonNode)mapper.readTree(jp);
                JsonNode timestampNode = rootNode.findValue("range").findValue("timestamp");
                String from = Tools.elasticSearchTimeFormatToISO8601(timestampNode.findValue("from").asText());
                String to = Tools.elasticSearchTimeFormatToISO8601(timestampNode.findValue("to").asText());
                this.boundaries = AbsoluteRange.create(from, to);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.boundaries;
    }
}

