/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.periodical.IndexRetentionThread;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexCountBasedRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexCountBasedRetentionStrategy.class);
    private final Indices indices;
    private final ActivityWriter activityWriter;

    public AbstractIndexCountBasedRetentionStrategy(Indices indices, ActivityWriter activityWriter) {
        this.indices = Objects.requireNonNull(indices);
        this.activityWriter = Objects.requireNonNull(activityWriter);
    }

    protected abstract Optional<Integer> getMaxNumberOfIndices();

    protected abstract void retain(String var1);

    @Override
    public void retain(IndexSet indexSet) {
        Map<String, Set<String>> deflectorIndices = indexSet.getAllDeflectorAliases();
        int indexCount = deflectorIndices.size();
        Optional<Integer> maxIndices = this.getMaxNumberOfIndices();
        if (!maxIndices.isPresent()) {
            LOG.warn("No retention strategy configuration found, not running index retention!");
            return;
        }
        if (indexCount <= maxIndices.get()) {
            LOG.debug("Number of indices ({}) lower than limit ({}). Not performing any retention actions.", (Object)indexCount, (Object)maxIndices.get());
            return;
        }
        int removeCount = indexCount - maxIndices.get();
        String msg = "Number of indices (" + indexCount + ") higher than limit (" + maxIndices.get() + "). " + "Running retention for " + removeCount + " indices.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
        this.runRetention(indexSet, deflectorIndices, removeCount);
    }

    private void runRetention(IndexSet indexSet, Map<String, Set<String>> deflectorIndices, int removeCount) {
        for (String indexName : IndexHelper.getOldestIndices(deflectorIndices.keySet(), removeCount)) {
            if (deflectorIndices.get(indexName).contains(indexSet.getWriteIndexAlias())) {
                LOG.info("Not running retention against current deflector target <{}>.", (Object)indexName);
                continue;
            }
            if (this.indices.isReopened(indexName)) {
                LOG.info("Not running retention against reopened index <{}>.", (Object)indexName);
                continue;
            }
            String strategyName = this.getClass().getCanonicalName();
            String msg = "Running retention strategy [" + strategyName + "] for index <" + indexName + ">";
            LOG.info(msg);
            this.activityWriter.write(new Activity(msg, IndexRetentionThread.class));
            this.retain(indexName);
        }
    }
}

