/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import au.com.bytecode.opencsv.CSVParser;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.inputs.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvConverter
extends Converter {
    private static final Logger LOG = LoggerFactory.getLogger(CsvConverter.class);
    private final String[] fieldNames;
    private final char separator;
    private final char quoteChar;
    private final char escapeChar;
    private final boolean strictQuotes;
    private final boolean trimLeadingWhiteSpace;

    public CsvConverter(Map<String, Object> config) throws ConfigurationException {
        super(Converter.Type.CSV, config);
        try {
            String columnHeader = (String)config.get("column_header");
            if (columnHeader == null || columnHeader.isEmpty()) {
                throw new ConfigurationException("Missing column headers.");
            }
            this.separator = this.firstCharOrDefault(config.get("separator"), ',');
            this.quoteChar = this.firstCharOrDefault(config.get("quote_char"), '\"');
            this.escapeChar = this.firstCharOrDefault(config.get("escape_char"), '\\');
            this.strictQuotes = (Boolean)MoreObjects.firstNonNull((Object)((Boolean)config.get("strict_quotes")), (Object)false);
            this.trimLeadingWhiteSpace = (Boolean)MoreObjects.firstNonNull((Object)((Boolean)config.get("trim_leading_whitespace")), (Object)true);
            CSVParser parser = this.getCsvParser();
            this.fieldNames = parser.parseLine(columnHeader);
            if (this.fieldNames.length == 0) {
                throw new ConfigurationException("No field names found.");
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid configuration for CsvConverter");
        }
    }

    @Override
    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        CSVParser parser = this.getCsvParser();
        HashMap fields = Maps.newHashMap();
        try {
            String[] strings = parser.parseLine(value);
            if (strings.length != this.fieldNames.length) {
                LOG.error("Different number of columns in CSV data ({}) and configured field names ({}). Discarding input.", (Object)strings.length, (Object)this.fieldNames.length);
                return null;
            }
            for (int i = 0; i < strings.length; ++i) {
                fields.put(this.fieldNames[i], strings[i]);
            }
        }
        catch (IOException e) {
            LOG.error("Invalid CSV input, discarding input", (Throwable)e);
            return null;
        }
        return fields;
    }

    private char firstCharOrDefault(Object configValue, char defaultValue) {
        String s;
        if (configValue != null && (s = String.valueOf(configValue)).length() > 0) {
            return s.charAt(0);
        }
        return defaultValue;
    }

    private CSVParser getCsvParser() {
        return new CSVParser(this.separator, this.quoteChar, this.escapeChar, this.strictQuotes, this.trimLeadingWhiteSpace);
    }

    @Override
    public boolean buildsMultipleFields() {
        return true;
    }
}

