/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.streams.StreamImpl;
import org.graylog2.streams.StreamRuleImpl;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.graylog2.streams.config.DefaultStreamCreated;
import org.graylog2.streams.events.StreamsChangedEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamMigrationPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamMigrationPeriodical.class);
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final ClusterEventBus clusterEventBus;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public DefaultStreamMigrationPeriodical(StreamService streamService, StreamRuleService streamRuleService, ClusterEventBus clusterEventBus, ClusterConfigService clusterConfigService) {
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.clusterEventBus = clusterEventBus;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public void doRun() {
        ObjectId id = new ObjectId("000000000000000000000001");
        ImmutableMap fields = ImmutableMap.builder().put((Object)"title", (Object)"All messages").put((Object)"description", (Object)"Stream containing all messages").put((Object)"disabled", (Object)false).put((Object)"created_at", (Object)DateTime.now((DateTimeZone)DateTimeZone.UTC)).put((Object)"creator_user_id", (Object)"local:admin").put((Object)"matching_type", (Object)Stream.MatchingType.DEFAULT.name()).put((Object)"is_default_stream", (Object)true).build();
        StreamImpl stream = new StreamImpl(id, (Map<String, Object>)fields, Collections.emptyList(), Collections.emptySet());
        StreamRuleImpl streamRule = new StreamRuleImpl((Map<String, Object>)ImmutableMap.builder().put((Object)"type", (Object)StreamRuleType.ALWAYS_MATCH.getValue()).put((Object)"field", (Object)"timestamp").put((Object)"inverted", (Object)false).put((Object)"stream_id", (Object)id).put((Object)"description", (Object)"Match all messages").build());
        try {
            this.streamService.save(stream);
            this.streamRuleService.save(streamRule);
            LOG.info("Successfully created default stream: {}", (Object)stream.getTitle());
            this.clusterConfigService.write(DefaultStreamCreated.create());
            this.clusterEventBus.post(StreamsChangedEvent.create(stream.getId()));
        }
        catch (ValidationException e) {
            LOG.error("Couldn't create default stream", (Throwable)e);
        }
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.clusterConfigService.get(DefaultStreamCreated.class) == null;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

